/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGLinearGradient.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGLinearGradient.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

 
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGLinearGradient</code> is a implementation class for Scalable Vector Graphics (SVG) 
 * "linearGradient" elements. 
 */
public class SVGLinearGradient extends SVGLinearGradientBase {
    private Element implementation;
    static final long serialVersionUID = 4666496503569576603L;	
	/**
	 * Sole constructor.
	 */
	public SVGLinearGradient() {
		super();
		setTagName("linearGradient");
	}	
		
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "linearGradient" element
	 * 	
	 * @param Document the target SVG Document
	 * @param String the x1
	 * @param String the x2
	 * @param String the y1
	 * @param String the y2
	 * @param String the spreadMethod
	 * @return Element the implementation 
	 * @throws NullPointerException ???
	 */
	public Element doImplementation(Document svgDocument, String x1, String x2, String y1, String y2, String spreadMethod, String gradientUnits) throws NullPointerException {	
		setX1(x1);
		setX2(x2);
		setY1(y1);
		setY2(y2);
		setSpreadMethod(spreadMethod);	
		setGradientUnits(gradientUnits);
				
		try {
			implementation = super.doImplementation(svgDocument);			
		} catch (DOMException e) {}				
		
		return implementation;	
	}
				
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}	
}
