/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGLinearGradientBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGLinearGradientBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGLinearGradientBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "linearGradient" elements.
 */
abstract public class SVGLinearGradientBase extends SVGContainerBase implements ISVGLinearGradientBase, Serializable {

	private String x1;
	private String x2;
	private String y1;
	private String y2;
	private String spreadMethod;
	private String gradientUnits;
	
	/**
	 * Calls the superclass to create the SVG container element and then sets any non-<code>null</code> base 
	 * attributes. Calls the <code>doImplementation(Document)</code> method on all children - any 
	 * children returning <code>null</code> will not have elements added to the container.
	 * 	
	 * @param Document the target SVG Document
	 * @return Element the container implementation or <code>null</code> if the element was not created.
	 * @throws DOMException if the tag name contains an illegal character.	
	 * @throws NullPointerException if any child elements are <code>null</code>.
	 */
	public Element doImplementation(Document svgDocument) {
		Element linearGradientElement;
					
		// get our element	
		linearGradientElement = super.doImplementation(svgDocument);

		//set any non-null attributes we know about
		if (linearGradientElement != null) {				
				
			if (x1 != null) {			
				linearGradientElement.setAttribute("x1", x1);
			}
			if (x2 != null) {			
				linearGradientElement.setAttribute("x2", x2);
			}
			if (y1 != null) {			
				linearGradientElement.setAttribute("y1", y1);
			}
			if (y2 != null) {			
				linearGradientElement.setAttribute("y2", y2);
			}
			if (spreadMethod != null) {			
				linearGradientElement.setAttribute("spreadMethod", spreadMethod);
			}
			if (gradientUnits != null) {			
				linearGradientElement.setAttribute("gradientUnits", gradientUnits);
			}
		}		
		return linearGradientElement;	
	}


	/**
	 * Returns the spreadMethod.
	 * @return String
	 */
	public String getSpreadMethod() {
		return spreadMethod;
	}

	/**
	 * Returns the x1.
	 * @return String
	 */
	public String getX1() {
		return x1;
	}

	/**
	 * Returns the x2.
	 * @return String
	 */
	public String getX2() {
		return x2;
	}

	/**
	 * Returns the y1.
	 * @return String
	 */
	public String getY1() {
		return y1;
	}

	/**
	 * Returns the y2.
	 * @return String
	 */
	public String getY2() {
		return y2;
	}

	/**
	 * Sets the spreadMethod.
	 * @param spreadMethod The spreadMethod to set
	 */
	public void setSpreadMethod(String spreadMethod) {
		this.spreadMethod = spreadMethod;
	}

	/**
	 * Sets the x1.
	 * @param x1 The x1 to set
	 */
	public void setX1(String x1) {
		this.x1 = x1;
	}

	/**
	 * Sets the x2.
	 * @param x2 The x2 to set
	 */
	public void setX2(String x2) {
		this.x2 = x2;
	}

	/**
	 * Sets the y1.
	 * @param y1 The y1 to set
	 */
	public void setY1(String y1) {
		this.y1 = y1;
	}

	/**
	 * Sets the y2.
	 * @param y2 The y2 to set
	 */
	public void setY2(String y2) {
		this.y2 = y2;
	}

	/**
	 * Returns the gradientUnits.
	 * @return String
	 */
	public String getGradientUnits() {
		return gradientUnits;
	}

	/**
	 * Sets the gradientUnits.
	 * @param gradientUnits The gradientUnits to set
	 */
	public void setGradientUnits(String gradientUnits) {
		this.gradientUnits = gradientUnits;
	}

}