/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPath.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPath.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGPath</code> is a implementation class for Scalable Vector Graphics (SVG) 
 * "path" elements. 
 * 

 * $Revision: 1.2 $
 */
public class SVGPath extends SVGPathBase implements Serializable {
	Element implementation;
	static final long serialVersionUID = 5612761126925425731L;
	
		/**
		 * Sole constructor.
		 */
		public SVGPath() {
			super();
			setTagName("path");
		}	
		
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "path" element 
	 * @param Document the target SVG Document
	 * @param String pathData
	 * @param String pathLength
	 * @param String style
	 * @param String transform
	 * @return
	 * @throws NullPointerException ???
	 */
	public Element doImplementation(Document svgDocument, String pathData, String pathLength, String style, String transform) throws NullPointerException {	
		setPathData(pathData);
		setPathLength(pathLength);
		setStyle(style);
		try {
			implementation = super.doImplementation(svgDocument);		
		} catch (DOMException e) {}
		
		return implementation;
	}
		

	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}			
}
