/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPathBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPathBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGPathBase</code> is an abstract base class for classes which generate
 * Scalable Vector Graphics (SVG) "path" elements.
 * 

 * $Revision: 1.1 $
 */
public abstract class SVGPathBase extends SVGGraphicBase
implements ISVGPathBase, Serializable {

	private String pathData;
	private String pathLength;
	private String style;
	private String transform;
	/**
	 * @see ISVGPolylineBase#doImplementation()
	 */
	public Element doImplementation(Document svgDocument) throws DOMException {
		Element PathElement;
		
		// nothing to do		
		if (pathData == null ) {
			return null;
		}	
		
		// get our element
		PathElement = super.doImplementation(svgDocument);	
		
		// set any non-null attributes we know about
		if (PathElement != null) {					
			PathElement.setAttribute("d", pathData);	
			if (pathLength != null) {
				PathElement.setAttribute("pathLength", pathLength);
			}
			if (style != null) {	
				PathElement.setAttribute("style", style);
			}
			if (transform != null) {	
				PathElement.setAttribute("transform", transform);
			}	
		}

		return PathElement;
	}		

	/**
	 * @see ISVGPathBase#getPathData()
	 * @return String pathData
	 */
	public String getPathData() {
		return pathData;
	}

	/**
	 * @see ISVGPathBase#getPathLength()
	 * @return String pathLength
	 */
	public String getPathLength() {
		return pathLength;
	}

	/**
	 * @see ISVGPathBase#getStyle()
	 * @return String style
	 */
	public String getStyle() {
		return style;
	}

	/**
	 * @see ISVGPathBase#getTransform()
	 * @return String transform
	 */
	public String getTransform() {
		return transform;
	}

	/**
	 * @see ISVGPathBase#setPathData(String) 
	 * @param string pathData
	 */
	public void setPathData(String string) {
		pathData = string;
	}

	/**
	 * @see ISVGPathBase#setPathLength(String) 
	 * @param string pathLength
	 */
	public void setPathLength(String string) {
		pathLength = string;
	}

	/**
	 * @see ISVGPathBase#setStyle(String) 
	 * @param string style
	 */
	public void setStyle(String string) {
		style = string;
	}

	/**
	 * @see ISVGPathBase#setTransform(String) 
	 * @param string transform
	 */
	public void setTransform(String string) {
		transform = string;
	}

}
