/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPolygonBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPolygonBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGPolygonBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "polygon" elements.
 *
 * $Revision: 1.1 $
 */
abstract public class SVGPolygonBase	extends SVGGraphicBase	implements ISVGPolygonBase, Serializable {		
	private String points;
			
	/**
	 * @see ISVGPolygonBase#doImplementation()
	 */
	public Element doImplementation(Document svgDocument) throws DOMException {
		Element polygonElement;
		
		// nothing to do		
		if (points == null) {
			return null;
		}	
		
		// get our element
		polygonElement = super.doImplementation(svgDocument);	
		
		// set any non-null attributes we know about
		if (polygonElement != null) {					
			polygonElement.setAttribute("points", points);		
		}
		
		return polygonElement;
	}		
	
	/**
	 * @see ISVGPolygonBase#getPoints()
	 */
	public String getPoints() {
		return points;
	}

	/**
	 * @see ISVGPolygonBase#setPoints()
	 */
	public void setPoints(String points) {
		this.points = points;
	}
}
