/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPolyline.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPolyline.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * <code>SVGPolyline</code> is a implementation class for Scalable Vector Graphics (SVG) 
 * "polyline" elements. 
 * 

 * $Revision: 1.2 $
 */

public class SVGPolyline extends SVGPolylineBase implements Serializable {
	Element implementation;
	static final long serialVersionUID = -8085804720280168772L;	
	/**
	 * Sole constructor.
	 */
	public SVGPolyline() {
		super();
		setTagName("polyline");
	}	
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase#doImplementation(org.w3c.dom.Document)
	 */
	public Element doImplementation(Document svgDocument) throws DOMException {
		return super.doImplementation(svgDocument);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGBase#getImplementation()
	 */
	public Element getImplementation() {
		return implementation;
	}

}
