/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPolylineBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPolylineBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGPolylineBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "polyline" elements.
 * 

 * $Revision: 1.1 $
 */
abstract public class SVGPolylineBase
	extends SVGGraphicBase
	implements ISVGPolylineBase, Serializable {
		private String points;
		/**
		 * @see ISVGPolylineBase#doImplementation()
		 */
		public Element doImplementation(Document svgDocument) throws DOMException {
			Element polylineElement;
		
			// nothing to do		
			if (points == null) {
				return null;
			}	
		
			// get our element
			polylineElement = super.doImplementation(svgDocument);	
		
			// set any non-null attributes we know about
			if (polylineElement != null) {					
				polylineElement.setAttribute("points", points);		
			}
		
			return polylineElement;
		}		

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGPolylineBase#getPoints()
	 */
	public String getPoints() {
		return points;
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGPolylineBase#setPoints(java.lang.String)
	 */
	public void setPoints(String points) {
		this.points = points;

	}

}
