/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGRectangle.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGRectangle.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGRectangle</code> is an implementation class for Scalable Vector Graphics (SVG) 
 * "rect" elements. 
 *
 * $Revision: 1.2 $
 */
public class SVGRectangle extends SVGRectangleBase implements Serializable {
	Element implementation;
	static final long serialVersionUID = -6461046538078094910L;	
	/**
	 * Sole constructor.
	 */
	public SVGRectangle() {
		super();
		setTagName("rect");
	}	
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "rect" element 
	 * 	
	 * @param Document the target SVG Document
	 * @param String the width
	 * @param String the height
	 * @return Element the implementation.
	 * @throws NullPointerException ???
	 */
	public Element doImplementation(Document svgDocument, String width, String height) throws NullPointerException {	
		setWidth(width);
		setHeight(height);
		
		try {		
			implementation = super.doImplementation(svgDocument);		
		} catch (DOMException e) {}
		
		return implementation;
	}		
	
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}

}
