/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGRectangleBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGRectangleBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGRectangleBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "rectangle" elements.
 *
 * $Revision: 1.1 $
 */
abstract public class SVGRectangleBase extends SVGGraphicBase implements ISVGRectangleBase, Serializable {	
	private String width;
	private String height;	
				
	/**
	 * @see ISVGRectangleBase#doImplementation()
	 */
	public Element doImplementation(Document svgDocument) throws DOMException {
		Element rectElement;
		
		// nothing to do
		if (width == null || height == null) {
			return null;
		}	
		
		// get our element
		rectElement = super.doImplementation(svgDocument);			
		
		// set any non-null attributes we know about
		if (rectElement != null) {				
			rectElement.setAttribute("width", width);
			rectElement.setAttribute("height", height);
		}			
		return rectElement;
	}		
		
	/**
	 * @see ISVGRectangleBase#getHeight()
	 */
	public String getHeight() {
		return height;
	}

	/**
	 * @see ISVGRectangleBase#getWidth()
	 */
	public String getWidth() {
		return width;
	}

	/**
	 * @see ISVGRectangleBase#setHeight()
	 */
	public void setHeight(String height) {
		this.height = height;
	}

	/**
	 * @see ISVGRectangleBase#setWidth()
	 */
	public void setWidth(String width) {
		this.width = width;
	}
}
