/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGRotateText.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGRotateText.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

import org.eclipse.tptp.platform.report.chart.svg.internal.part.IConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGRotateText</code> is an implementation class for Scalable Vector Graphics (SVG) 
 * "text" elements. 
 *
 * $Revision: 1.2 $
 */
public class SVGRotateText extends SVGText {

	static final long serialVersionUID = 195789502628577102L;
	protected Dimension2D boundingBox;
	protected int anchorStyle; 
	protected double degrees;
	protected Font measureFont;
	protected static BufferedImage bi;
	protected static Graphics2D graphics;
	
	static {
		bi = new BufferedImage(1, 1, BufferedImage.TYPE_INT_RGB);
		graphics = bi.createGraphics();
	}
	
	public SVGRotateText(){
		boundingBox = new Dimension(0,0);
		anchorStyle = IConstants.TEXT_ANCHOR_MIDDLE;
	}

	public Element doImplementation(Document svgDocument)
			throws DOMException, NullPointerException {
		return super.doImplementation(svgDocument);
//		Element normLabel = super.doImplementation(svgDocument);
//		implementation = super.doImplementation(svgDocument);
//		int fontSize = Integer.parseInt(this.getFontSize());
//		double midPointY = 0;
//		double midPointX = 0;
//		if (anchorStyle != IConstants.TEXT_ANCHOR_MIDDLE)
//			midPointY = fontSize / 2;
////		if (anchorStyle == IConstants.TEXT_ANCHOR_START)
////			midPointX = -midPointY;
////		else if (anchorStyle == IConstants.TEXT_ANCHOR_END)
////			midPointX = midPointY;
//		implementation.setAttribute("transform", "translate("+this.getXCoordinate()+","+(Double.parseDouble(this.getYCoordinate())-midPointY)+
//				                   ") rotate("+degrees+") translate("+midPointX+","+midPointY+")");
//		if (this.getXCoordinate() != null) {
//			implementation.removeAttribute("x");
//		}	
//		
//		if (this.getYCoordinate() != null) {
//			implementation.removeAttribute("y");
//		}
//		
//		boundingBox = SVGRotateText.getBoundingBox(this.getText(), 0, new Font("arial", Font.PLAIN, IConstants.BASE_FONT_SIZE));
//
//		Element rect = svgDocument.createElement("rect");
//		rect.setAttribute("x",(Double.parseDouble(this.getXCoordinate()))+"" );
//		rect.setAttribute("y",(Double.parseDouble(this.getYCoordinate()))+"" );
//		rect.setAttribute("height",(2)+"" );
//		rect.setAttribute("width",(2)+"" );
//		rect.setAttribute("fill","red" );
//		
//		Element group = svgDocument.createElement("g");
//		group.appendChild(rect);
//		group.appendChild(implementation);
//		group.appendChild(normLabel);
//		return group;
	}
	
	

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.ISVGTextBase#getFontSize()
	 */
	public String getFontSize() {
		if (super.getFontSize() == null)
			return ""+IConstants.BASE_FONT_SIZE;
		else return super.getFontSize();
	}

	public String getFontFamily() {
		if (super.getFontFamily() == null)
			return "arial";
		else return super.getFontFamily();
	}

	public String getFontStyle() {
		if (super.getFontStyle() == null)
			return "normal";
		else return super.getFontStyle();
	}

	public static Dimension2D getBoundingBox(String text, double degrees, Font measureFont) {
		Rectangle2D rectangle = measureFont.getStringBounds(text, graphics.getFontRenderContext());
		double radDegrees = degrees*Math.PI/180;
		Dimension2D boundingBox = new Dimension(0,0);
		boundingBox.setSize( rectangle.getWidth()*Math.cos(radDegrees)+rectangle.getHeight()*Math.sin(radDegrees) , rectangle.getWidth()*Math.sin(radDegrees)+rectangle.getHeight()*Math.cos(radDegrees));

		return boundingBox;
	}
	
	private int getFontAWTStyle(){
		if ((getFontStyle() != null) && (getFontStyle().trim().equalsIgnoreCase("bold")))
			return Font.BOLD;
		else if ((getFontStyle() != null) && (getFontStyle().trim().equalsIgnoreCase("italic")))
			return Font.ITALIC;
		else
			return Font.PLAIN;
	}
	
	public Dimension2D getBoundingBox() {
		measureFont = new Font(this.getFontFamily(), getFontAWTStyle(), Integer.parseInt(this.getFontSize()));

		Rectangle2D rectangle = measureFont.getStringBounds(getText(), graphics.getFontRenderContext());
		double radDegreees = degrees*Math.PI/180;
		boundingBox.setSize( rectangle.getWidth()*Math.cos(radDegreees)+rectangle.getHeight()*Math.sin(radDegreees) , rectangle.getWidth()*Math.sin(radDegreees)+rectangle.getHeight()*Math.cos(radDegreees));
		
		return boundingBox;
	}

	/**
	 * @return Returns the anchorStyle.
	 */
	public int getAnchorStyle() {
		return anchorStyle;
	}

	/**
	 * @return Returns the degrees.
	 */
	public double getDegrees() {
		return degrees;
	}
	/**
	 * @param degrees The degrees to set.
	 */
	public void setDegrees(double degrees) {
		this.degrees = degrees;
	}
	/**
	 * @param anchorStyle The anchorStyle to set.
	 */
	public void setAnchorStyle(int anchorStyle) {
		this.anchorStyle = anchorStyle;
	}
}