/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGScript.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGScript.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * 
 * <code>SVGScript</code> is an is an implementation class for Scalable Vector Graphics (SVG) 
 * "script" elements.  
 *
 */
public class SVGScript extends SVGBase {

	private Element implementation;
	static final long serialVersionUID = -6753429640054522891L;	
	private String defaultScripts = null;
	private String userScript = null;
	
		/**
		 * Sole constructor.
		 */
		public SVGScript() {
			super();
			setTagName("script");
		}
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "script" element 
	 * 	
	 * @param svgDocument the target SVG Document
	 * @return Element the implementation.
	 * @throws DOMException
	 * @throws NullPointerException
	 */
	public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {
		implementation = super.doImplementation(svgDocument);

		if (this.defaultScripts != null) {
			// Add default ECMAScripts		
			Utilities.assertion(this.userScript == null);
			CDATASection domCDATA = svgDocument.createCDATASection(this.defaultScripts);
			implementation.appendChild(domCDATA);
		} 
		else if (this.userScript != null) {
			// Add user ECMAScript		
			Utilities.assertion(this.defaultScripts == null);
			implementation.setAttribute("xlink:href", this.userScript);
		}
		else {
			// Should not get here
			Utilities.assertion(false); 
		}
		//change mimetype from "text/ecmascript" to "text/javascript"
		implementation.setAttribute("type", "text/javascript");
		
		return implementation;		
	}	
	
	
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}
	
	/**
	 * Sets the default script string to emit
	 * 
	 * @param scriptsParm the String containing the scripts
	 */
	public void setDefaultScripts(String scriptsString) {
		this.defaultScripts = scriptsString;
	}
	
	/**
	 * Sets the user script to emit
	 * 
	 * @param scriptsParm the String containing the scripts
	 */
	public void setUserScript(String scriptFileName) {
		this.userScript = scriptFileName;
	}
}
