/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSet.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSet.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGSet</code> is a implementation class for Scalable Vector Graphics (SVG) 
 * "set" elements. 
 * 

 * $Revision: 1.2 $
 */
public class SVGSet extends SVGSetBase implements Serializable {
	private Element implementation;
	static final long serialVersionUID = -8621310481239631036L;	
	/**
	 * Sole constructor.
	 */
	public SVGSet() {
		super();
		setTagName("set");
	}	
		
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "set" element 
	 * 	
	 * @param Document the target SVG Document	
	 * @return Element the implementation.
	 */
	public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {		
		
		return(implementation = super.doImplementation(svgDocument));		
	}	
	
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGSet#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}

}
