/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSetBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSetBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGSetBase</code> is an abstract base class for classes which generate  
 * Scalable Vector Graphics (SVG) "set" elements. 
 * 

 * $Revision: 1.1 $
 */
public abstract class SVGSetBase extends SVGBase implements ISVGSetBase, Serializable {	
	private String attributeName;
	private String attributeType;
	private String to;	
	private String from;	
	private String begain;	
	private String end;
	private String dur;
	private String fill;	

	/**
	 * @see ISVGSetBase#doImplementation()
	 */
	public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {	
		Element setElement;		
	
		// get our element
		setElement = super.doImplementation(svgDocument);
		
		// create the set node and set any non-null attributes we know about
		if (setElement != null) {					     	   	    	
		   	if (attributeName != null) {
		    	setElement.setAttribute("attributeName",attributeName);
		    }

		   	if (attributeType != null) {
		    	setElement.setAttribute("attributeType",attributeType);
		    }
		   	if (to != null) {
		    	setElement.setAttribute("to",to);
		    }
		   	if (from != null) {
		    	setElement.setAttribute("from",from);
		    }
		   	if (begain != null) {
		    	setElement.setAttribute("begain",begain);
		    }
		   	if (end != null) {
		    	setElement.setAttribute("end",end);
		    }
		   	if (dur != null) {
		    	setElement.setAttribute("dur",dur);
		    }
		   	if (fill != null) {
		    	setElement.setAttribute("fill",fill);
		    }		    		    		    		    		    		    
	    
		} 	   
		return setElement; 	   
	}    
	

	/**
	 * @see ISVGSetBase#getAttributeName()
	 */
	public String getAttributeName() {
		return attributeName;
	}

	/**
	 * @see ISVGSetBase#getAttributeType()
	 */
	public String getAttributeType() {
		return attributeType;
	}

	/**
	 * @see ISVGSetBase#getBegain()
	 */
	public String getBegain() {
		return begain;
	}

	/**
	 * @see ISVGSetBase#getDur()
	 */
	public String getDur() {
		return dur;
	}

	/**
	 * @see ISVGSetBase#getEnd()
	 */
	public String getEnd() {
		return end;
	}

	/**
	 * @see ISVGSetBase#getFill()
	 */
	public String getFill() {
		return fill;
	}

	/**
	 * @see ISVGSetBase#getFrom()
	 */
	public String getFrom() {
		return from;
	}

	
	/**
	 * @see ISVGSetBase#getTo()
	 */
	public String getTo() {
		return to;
	}

	/**
	 * @see ISVGSetBase#setAttributeName()
	 */
	public void setAttributeName(String attributeName) {
		this.attributeName = attributeName;
	}

	/**
	 * @see ISVGSetBase#setAttributeType()
	 */
	public void setAttributeType(String attributeType) {
		this.attributeType = attributeType;
	}

	/**
	 * @see ISVGSetBase#setBegain()
	 */
	public void setBegain(String begain) {
		this.begain = begain;
	}

	/**
	 * @see ISVGSetBase#setDur()
	 */
	public void setDur(String dur) {
		this.dur = dur;
	}

	/**
	 * @see ISVGSetBase#setEnd()
	 */
	public void setEnd(String end) {
		this.end = end;
	}

	/**
	 * @see ISVGSetBase#setFill()
	 */
	public void setFill(String fill) {
		this.fill = fill;
	}

	/**
	 * @see ISVGSetBase#setFrom()
	 */
	public void setFrom(String from) {
		this.from = from;
	}

	/**
	 * @see ISVGSetBase#setTo()
	 */
	public void setTo(String to) {
		this.to = to;
	}

}
