/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGStop.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGStop.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGStop</code> is a implementation class for Scalable Vector Graphics (SVG) 
 * "stop" elements. 
 */
public class SVGStop extends SVGStopBase {
    private Element implementation;
    static final long serialVersionUID = -8172710128272501831L;	
	/**
	 * Sole constructor.
	 */
	public SVGStop() {
		super();
		setTagName("stop");
	}	
		
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "stop" element
	 * 	
	 * @param Document the target SVG Document
	 * @param String the offset
	 * @param String the style
	 * @return Element the implementation 
	 * @throws NullPointerException ???
	 */
	public Element doImplementation(Document svgDocument, String offset, String style) throws NullPointerException {	
		setOffset(offset);
		setStyle(style);
				
		try {
			implementation = super.doImplementation(svgDocument);			
		} catch (DOMException e) {}				
		
		return implementation;	
	}
				
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}	
}
