/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGStopBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGStopBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGStopBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "stop" elements.
 */
abstract public class SVGStopBase  extends SVGGraphicBase implements ISVGStopBase, Serializable {

	private String offset;
	private String style;
	
	/**
	 * Calls the superclass to create the SVG container element and then sets any non-<code>null</code> base 
	 * attributes. Calls the <code>doImplementation(Document)</code> method on all children - any 
	 * children returning <code>null</code> will not have elements added to the container.
	 * 	
	 * @param Document the target SVG Document
	 * @return Element the container implementation or <code>null</code> if the element was not created.
	 * @throws DOMException if the tag name contains an illegal character.	
	 * @throws NullPointerException if any child elements are <code>null</code>.
	 */
	public Element doImplementation(Document svgDocument) {
		Element stopElement;
					
		// get our element	
		stopElement = super.doImplementation(svgDocument);

		//set any non-null attributes we know about
		if (stopElement != null) {				
				
			if (offset != null) {			
				stopElement.setAttribute("offset", offset);
			}
			if (style != null) {			
				stopElement.setAttribute("style", style);
			}
		}		
		return stopElement;	
	}

	/**
	 * Returns the offset.
	 * @return String
	 */
	public String getOffset() {
		return offset;
	}

	/**
	 * Returns the style.
	 * @return String
	 */
	public String getStyle() {
		return style;
	}

	/**
	 * Sets the offset.
	 * @param offset The offset to set
	 */
	public void setOffset(String offset) {
		this.offset = offset;
	}

	/**
	 * Sets the style.
	 * @param style The style to set
	 */
	public void setStyle(String style) {
		this.style = style;
	}

}
