/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGStyle.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGStyle.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**

 *
 * <code>SVGStyle</code> is an is an implementation class for Scalable Vector Graphics (SVG) 
 * "style" elements.  
 * 
 * $Revision: 1.2 $
 */
public class SVGStyle extends SVGStyleBase {
	private Element implementation;
	static final long serialVersionUID = 3069603505629547543L;	
		/**
		 * Sole constructor.
		 */
		public SVGStyle() {
			super();
			setTagName("style");
		}
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "style" element 
	 * 	
	 * @param svgDocument Document the target SVG Document
	 * @param type String the type
	 * @param id String the ID
	 * @param cdata String the CDATA
	 * @return Element the implementation.
	 * @throws DOMException
	 * @throws NullPointerException
	 */
	public Element doImplementation(Document svgDocument, String type, String id, String cdata) throws DOMException, NullPointerException {		
		setType(type);
		setId(id);
		setCdata(cdata);	
		return(implementation = super.doImplementation(svgDocument));		
	}	
	
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "style" element 
	 * 	
	 * @param svgDocument Document the target SVG Document
	 * @return Element the implementation.
	 * @throws DOMException
	 * @throws NullPointerException
	 */
	public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {		
		return(implementation = super.doImplementation(svgDocument));		
	}	
	
	
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}

}
