/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGStyleBase.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGStyleBase.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**

 *
 * <code>SVGStyleBase</code> is an base class for classes which generate
 * Scalable Vector Graphics (SVG) "style" elements.
 */
public class SVGStyleBase extends SVGContainerBase {
	private Element implementation;
	private String type;
	private String id;
	private String cdata;
	static final long serialVersionUID = 7178288679551219298L;
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGBase#getImplementation()
	 */
	public Element getImplementation() {

		return null;
	}


	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "style" element 
	 * 	
	 * @param svgDocument Document the target SVG Document
	 * @param string CDATA values
	 * @return Element the implementation.
	 * @throws DOMException
	 * @throws NullPointerException
	 */
	public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {
		/*		createCDATASection;		
		*/
		if (cdata != null) {
			CDATASection domCDATA = svgDocument.createCDATASection(cdata);
			implementation = super.doImplementation(svgDocument);
			implementation.appendChild(domCDATA);
		}
		if (id != null) {
			implementation.setAttribute("id", id);
		}
		if (type != null) {
			implementation.setAttribute("type", type);
		}
		return implementation ;
	}
	
	/**
	 * @return
	 */
	public String getId() {
		return id;
	}

	/**
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param string
	 */
	public void setId(String string) {
		id = string;
	}

	/**
	 * @param string
	 */
	public void setType(String string) {
		type = string;
	}

	/**
	 * @return
	 */
	public String getCdata() {
		return cdata;
	}

	/**
	 * @param string
	 */
	public void setCdata(String string) {
		cdata = string;
	}

}
