/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSvg.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSvg.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGSvg</code> is an implementation class for Scalable Vector Graphics (SVG) 
 * "svg" elements. 
 *
 * $Revision: 1.2 $
 */
public class SVGSvg extends SVGDocumentFragmentBase implements Serializable {	
	private Element implementation;
	static final long serialVersionUID = 278010215979416056L;	
	private Vector definitions;
	private Vector definitions_element;
		
	/**
	 * Sole constructor.
	 */
	public SVGSvg() {
		super();
		definitions = new Vector();
		definitions_element = new Vector();
		setTagName("svg");
	}	
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase#doImplementation(org.w3c.dom.Document)
	 */
	public Element doImplementation(Document svgDocument) throws NullPointerException {	
		try {		
			implementation = super.doImplementation(svgDocument);		
		} catch (DOMException e) {}
		
		// add svg definitions
		setDefinitions(svgDocument);
		
		return implementation;
	}		
			
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "svg" element 
	 * 	
	 * @param Document the target SVG Document
	 * @param String the viewport width
	 * @param String the viewport height
	 * @return Element the implementation.
	 */
	public Element doImplementation(Document svgDocument, String width, String height) throws NullPointerException {	
		setWidth(width);
		setHeight(height);	
		
		try {		
			implementation = super.doImplementation(svgDocument);		
		} catch (DOMException e) {}
		
		// add svg definitions
		setDefinitions(svgDocument);
		
		return implementation;
	}		
			
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "svg" element 
	 * 	
	 * @param Document the target SVG Document
	 * @param String the viewport width
	 * @param String the viewport height
	 * @param String the user coordinate space
	 * @param String the aspectRatio to preserve	
	 * @return Element the implementation.
	 */
	public Element doImplementation(Document svgDocument, String width, String height, String viewbox, String preserveAspectRatio) throws NullPointerException {	
		setWidth(width);
		setHeight(height);	
		setViewbox(viewbox);
		setPreserveAspectRatio(preserveAspectRatio);	

		try {		
			implementation = super.doImplementation(svgDocument);		
		} catch (DOMException e) {}
		
		// add svg definitions
		setDefinitions(svgDocument);
		
		return implementation;
	}		
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "svg" element 
	 * 	
	 * @param Document the target SVG Document
	 * @param String the viewport width
	 * @param String the viewport height
	 * @param String the user coordinate space
	 * @param String the aspectRatio to preserve	
	 * @param String the x-coordinate
	 * @param String the y-coordinate
	 * @return Element the implementation.
	 */
	public Element doImplementation(Document svgDocument, String width, String height, String viewbox, String preserveAspectRatio, String x, String y) throws NullPointerException {	
		setWidth(width);
		setHeight(height);	
		setViewbox(viewbox);
		setPreserveAspectRatio(preserveAspectRatio);	
		setXCoordinate(x);
		setYCoordinate(y);	
		
		try {		
			implementation = super.doImplementation(svgDocument);		
		} catch (DOMException e) {}
		
		// add svg definitions
		setDefinitions(svgDocument);
		
		return implementation;
	}		
	
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}
	
	/**
	 * Add a new definition
	 * @param newDefinition
	 */
	public void addDefinition(SVGBase newDefinition) {
		definitions.add(newDefinition);
	}
	
	/**
	 * Add a new definition
	 * @param newDefinition
	 */
	public void addDefinition(Element newDefinition) {
		definitions_element.add(newDefinition);
	}
	
	/**
	 * Add a new Style
	 * @param newStyle
	 */
	public void addStyle(SVGBase newDefinition) {
		definitions.add(newDefinition);
	}
	

	private void setDefinitions(Document svgDocument) {
		if (definitions.size() != 0) {
			SVGDefinition def = new SVGDefinition();
			SVGBase[] defs = new SVGBase[definitions.size()];
			def.setChildren(defs);
			if (definitions_element.size() != 0) {
				def.setDefinitions(definitions_element);
			}
			int index = 0;
			for (Iterator i=definitions.iterator(); i.hasNext(); index++) {
				defs[index] = (SVGBase) i.next();
			}
			
			// make defs element as the first child of svg  
			if (implementation.getFirstChild() != null) {
				implementation.insertBefore(def.doImplementation(svgDocument), implementation.getFirstChild());
			} else {
				implementation.appendChild(def.doImplementation(svgDocument));
			}
		}
	}
}
