/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSymbol.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSymbol.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGSymbol</code> is an implementation class for Scalable Vector Graphics (SVG) 
 * "symbol" elements. 
 *
 * $Revision: 1.2 $
 */
public class SVGSymbol extends SVGSymbolBase implements Serializable {
	private Element implementation;
	static final long serialVersionUID = -1869483893162542005L;	
	/**
	 * Default constructor.
	 */
	public SVGSymbol() {
		super();
		setTagName("symbol");
	}
		
	/**
	 * Constructs an <code>SVGSymbol</code> with the specified viewbox and preserveAspectRatio.
	 */
	public SVGSymbol(String viewbox, String preserveAspectRatio) {
		super();
		setTagName("symbol");
		setViewbox(viewbox);
		setPreserveAspectRatio(preserveAspectRatio);
	}	
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "symbol" element 
	 * 	
	 * @param Document the target SVG Document
	 * @return Element the implementation.
	 */
	public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {			
		return(implementation = super.doImplementation(svgDocument));		
	}	
	
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}

}
