/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSymbolBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSymbolBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGSymbolBase</code> is an abstract base class for classes which generate
 * Scalable Vector Graphics (SVG) "symbol" elements.
 *
 * $Revision: 1.1 $
 */
abstract public class SVGSymbolBase extends SVGContainerBase implements ISVGSymbolBase, Serializable {
	private String viewbox;
	private String preserveAspectRatio;
		
	/**
	 * @see ISVGSymbolBase#doImplementation()
	 */
	public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {
		// get our element
		Element symbolElement = super.doImplementation(svgDocument);			
		
		//set any non-null attributes we know about
		if (symbolElement != null) {		
			if (viewbox != null) {
				symbolElement.setAttribute("viewbox", viewbox);
			}
			
			if (preserveAspectRatio != null) {
				symbolElement.setAttribute("preserveAspectRatio", preserveAspectRatio);
			}		
		}							
		return symbolElement;
	}			

	/**
	 * @see ISVGSymbolBase#getPreserveAspectRatio()
	 */
	public String getPreserveAspectRatio() {
		return preserveAspectRatio;
	}

	/**
	 * @see ISVGSymbolBase#getViewbox()
	 */
	public String getViewbox() {
		return viewbox;
	}

	/**
	 * @see ISVGSymbolBase#setPreserveAspectRatio()
	 */
	public void setPreserveAspectRatio(String newPreserveAspectRatio) {
		this.preserveAspectRatio = newPreserveAspectRatio;
	}

	/**
	 * @see ISVGSymbolBase#setViewbox()
	 */
	public void setViewbox(String newViewbox) {
		this.viewbox = newViewbox;
	}

}
