/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGText.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGText.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGText</code> is an implementation class for Scalable Vector Graphics (SVG) 
 * "text" elements. 
 *
 * $Revision: 1.2 $
 */
public class SVGText extends SVGTextBase implements Serializable {
	protected Element implementation;
	static final long serialVersionUID = -7081899471329505747L;	
	/**
	 * Sole constructor.
	 */
	public SVGText() {
		super();
		setTagName("text");
	}	
		
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "text" element 
	 * 	
	 * @param Document the target SVG Document
	 * @param String the text
	 * @return Element the implementation.
	 */
	public Element doImplementation(Document svgDocument, String text) throws DOMException, NullPointerException {		
		setText(text);	
		return(implementation = super.doImplementation(svgDocument));		
	}	
	
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}
}
