/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGTextBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGTextBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGTextBase</code> is an abstract base class for classes which generate
 * Scalable Vector Graphics (SVG) "text" elements. 
 *
 * $Revision: 1.1 $
 */
abstract public class SVGTextBase extends SVGGraphicBase implements ISVGTextBase, Serializable {		
	private String text;
	private String fontFamily;
	private String fontSize;
	private String fontWeight;	
	private String fontStyle;	
	private String textDecoration;
	private String wordSpacing;
	private String letterSpacing;	
	private String textAnchor;	


	/**
	 * @see ISVGTextBase#doImplementation()
	 */
	
			
	public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {	
		Element textElement;
		
		// nothing to do
		if (text == null) {
			return null;
		}	
		
		// get our element
		textElement = super.doImplementation(svgDocument);
		
		// create the text node and set any non-null attributes we know about
		if (textElement != null) {					     	   	    	
		   	textElement.appendChild(svgDocument.createTextNode(text));
		   	// this is a user-defined attribute for Javascript function
		   	// to do - find a way to determine the actual pixel length of the text
		   	
		   	// Commented out because:
		   	// 1. It is an incorrect use of "textLength" attribute. This attribute is 
		   	//    for adjusting text with the number of pixels given in this attribute.
		   	// 2. It causes problem with Batik transcoding.
			//textElement.setAttribute("textLength", Integer.toString(text.length()));
						
					
		   	if (fontFamily != null) {
		    	textElement.setAttribute("font-family",fontFamily);
		    }
		    
		    if (fontSize != null) {
		    	textElement.setAttribute("font-size", fontSize);
		    }
		    
		    if (fontWeight != null) {
		    	textElement.setAttribute("font-weight", fontWeight);
		    }
		    	    
		    if (fontStyle != null) {
		    	textElement.setAttribute("font-style", fontStyle);
		    }			
		  	
		    if (textDecoration != null) {
		    	textElement.setAttribute("text-decoration", textDecoration);
		    }
		    
		    if (wordSpacing != null) {
		    	textElement.setAttribute("word-spacing", wordSpacing);
		    }
		    
		    if (letterSpacing != null) {
		    	textElement.setAttribute("letter-spacing", letterSpacing);
		    }	    
		       
		    if (textAnchor != null) {
		    	textElement.setAttribute("text-anchor", textAnchor);
		    }
		} 	    
		return textElement; 	   
	}    
	
	/**
	 * @see ISVGTextBase#getText()
	 */

	public String getText() {
		return text;
	}
	
	/**
	 * @see ISVGTextBase#getFontFamily()
	 */

	public String getFontFamily() {
		return fontFamily;
	}

	/**
	 * @see ISVGTextBase#getFontSize()
	 */

	public String getFontSize() {
		return fontSize;
	}

	/**
	 * @see ISVGTextBase#getFontWeight()
	 */

	public String getFontWeight() {
		return fontWeight;
	}
	
	/**
	 * @see ISVGTextBase#getFontStyle()
	 */

	public String getFontStyle() {
		return fontStyle;
	}

	/**
	 * @see ISVGTextBase#getTextDecoration()
	 */

	public String getTextDecoration() {
		return textDecoration;
	}

	/**
	 * @see ISVGTextBase#getWordSpacing()
	 */

	public String getWordSpacing() {
		return wordSpacing;
	}
	
	/**
	 * @see ISVGTextBase#getLetterSpacing()
	 */

	public String getLetterSpacing() {
		return letterSpacing;
	}
	
	/**
	 * @see ISVGTextBase#getTextAnchor()
	 */

	public String getTextAnchor() {
		return textAnchor;
	}

	/**
	 * @see ISVGTextBase#setFontFamily()
	 */

	public void setFontFamily(String fontFamily) {
		this.fontFamily = fontFamily;
	}

	/**
	 * @see ISVGTextBase#setFontSize()
	 */

	public void setFontSize(String fontSize) {
		this.fontSize = fontSize;
	}

	/**
	 * @see ISVGTextBase#setFontStyle()
	 */

	public void setFontStyle(String fontStyle) {
		this.fontStyle = fontStyle;
	}

	/**
	 * @see ISVGTextBase#setFontWeight()
	 */

	public void setFontWeight(String fontWeight) {
		this.fontWeight = fontWeight;
	}

	/**
	 * @see ISVGTextBase#setLetterSpacing()
	 */

	public void setLetterSpacing(String letterSpacing) {
		this.letterSpacing = letterSpacing;
	}

	/**
	 * @see ISVGTextBase#setText()
	 */

	public void setText(String text) {
		this.text = text;
	}

	/**
	 * @see ISVGTextBase#setTextAnchor()
	 */

	public void setTextAnchor(String textAnchor) {
		this.textAnchor = textAnchor;
	}

	/**
	 * @see ISVGTextBase#setTextDecoration()
	 */

	public void setTextDecoration(String textDecoration) {
		this.textDecoration = textDecoration;
	}

	/**
	 * @see ISVGTextBase#setWordSpacing()
	 */

	public void setWordSpacing(String wordSpacing) {
		this.wordSpacing = wordSpacing;
	}

}
