/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGTitle.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGTitle.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGTitle</code> is an implementation class for Scalable Vector Graphics (SVG) 
 * "title" elements. 
 *
 * $Revision: 1.2 $
 */
public class SVGTitle extends SVGBase implements Serializable {
	private Element implementation;
	static final long serialVersionUID = -3726358676492958790L;
	
	/**
	 * Sole constructor.
	 */
	public SVGTitle() {
		super();
		setTagName("title");
	}	
		
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "title" element 
	 * 	
	 * @param Document the target SVG Document
	 * @param String the title text
	 * @return Element the implementation or <code>null</code> if <code>text</code> is <code>null</code>
	 * @throws NullPointerException if <code>svgDocument</code> is <code>null</code>.
	 */
	public Element doImplementation(Document svgDocument, String text) throws NullPointerException {	
		// nothing to do
		if (text == null) {
			return null;
		}			
		
		try {
			implementation = super.doImplementation(svgDocument);	
			implementation.appendChild(svgDocument.createTextNode(text));	
		} catch (DOMException e) {}
				
		return implementation;	
	}	
			
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}

}
