/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGUse.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGUse.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGUse</code> is an implementation class for Scalable Vector Graphics (SVG) 
 * "use" elements. 
 *
 * $Revision: 1.2 $
 */
public class SVGUse extends SVGUseBase implements Serializable {
	private Element implementation;
	static final long serialVersionUID = -4928492310081695919L;	
	/**
	 * Sole constructor.
	 */
	public SVGUse() {
		super();
		setTagName("use");
	}	
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "group" element. 
	 * 	
	 * @param Document the target SVG Document
	 * @param String the location URI
	 * @return Element the implementation or <code>null</code> if the element was not created. 	
	 */
	public Element doImplementation(Document svgDocument, String uri) {			
		setHref(uri);
		try {
			implementation = super.doImplementation(svgDocument);		
		} catch (DOMException e) {}
		return implementation;	
	}		
		
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}
}
