/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGUseBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGUseBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGUseBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) elements using the XML Linking Language (XLink) 
 * "href" global attribute.
 *
 * $Revision: 1.1 $
 */
abstract public class SVGUseBase extends SVGGraphicBase implements ISVGUseBase, Serializable {
	private String href;
	private String filter;
	
	/**
	 * @see ISVGUseBase#doImplementation()
	 */
	public Element doImplementation(Document svgDocument) throws DOMException {
		// get our element
		Element useElement = super.doImplementation(svgDocument);			
		
		// set any non-null attributes we know about
		if (useElement != null) {		
			if (href != null) {
				useElement.setAttribute("xlink:href", href);
			}				
			// set any non-null attributes we know about	
				if (filter != null) {
					useElement.setAttribute("filter", filter);
				}										
		}							
		return useElement;
	}			
		
	/**
	 * @see ISVGUseBase#getHref()
	 */

	public String getHref() {
		return href;
	}

	/**
	 * @see ISVGUseBase#setHref()
	 */

	public void setHref(String href) {
		this.href = href;
	}
	/**
	 * @return
	 */
	public String getFilter() {
		return filter;
	}

	/**
	 * @param string
	 */
	public void setFilter(String string) {
		filter = string;
	}

}
