/* ***********************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InputDOMDocument.java,v 1.3 2006/05/08 19:09:27 sleeloy Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InputDOMDocument.java,v 1.3 2006/05/08 19:09:27 sleeloy Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.eclipse.tptp.platform.report.chart.svg.internal.SVGGenerator;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;


/*
 *
 * Notes on error conditions:
 * - The value of an attribute that does not exist will be null.
 * - The value of a single node that does not list will be null.
 * - The value of a multiple node list that does not exist will be an empty list.
 * 
 *
 */
/**
 * This class creates an input object model backed by a DOM.
 * <p> 
 * The object model provides an option to maintain the DOM 
 * representation of the input. This class can be used to inspect the 
 * input DOM with the object model API. When the object model is modified by setter methods, 
 * the DOM will also be updated to reflect the changes. 
 * <p>
 * 
 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory 
 * 
 */
public class InputDOMDocument {
	
	protected Document _doc = null;
	
	/**
	 * Constructs an empty object model that will maintain a corresponding DOM representation. 
	 * 
	 * @see #getChart()
	 * @see #getDocument()
	 */
	public InputDOMDocument() {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder;
		try {
			builder = factory.newDocumentBuilder();
			DOMImplementation domImpl = builder.getDOMImplementation();
			DocumentType dType = domImpl.createDocumentType("svg", SVGGenerator.SVG_VERSION, SVGGenerator.SVG_DTD);			
			_doc = domImpl.createDocument("http://www.w3.org/2000/svg", "chart", dType);
		} catch (ParserConfigurationException e) {
			// should never happen
			Utilities.assertion(false);
		}
	}
	
	/**
	 * Instantiates the InputDOMDocument with an XML Document. 
	 * Use the getChart() method to get the object model representation of the 
	 * document element. The API of the object model can then be used to inspect and
	 * modify values of the input. If the object model is modified, the corresponding
	 * DOM will also be updated to reflect the changes. Use the getDocument() method
	 * to get the DOM representation of the object model at any time.
	 * 
	 * @see #getChart()
	 * @see #getDocument()
	 * @param doc the XML Document of the input
	 */
	public InputDOMDocument(Document doc) {
		_doc = doc;
	}
	
	/**
	 * Returns the Chart object - the root of the input object model.
	 * @return Chart object
	 */
	public Chart getChart() {
		Element element = (Element)_doc.getDocumentElement();
		return new ChartImpl(element);
	}
	
	/**
	 * Returns the XML Document object of the input.
	 * @return XML Document object of the input
	 */
	public Document getDocument() {
		return _doc;
	}

}
