/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InputFactory.java,v 1.1 2005/03/30 08:26:42 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InputFactory.java,v 1.1 2005/03/30 08:26:42 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input;


/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <p>
 * Here is some sample code to illustrate the usage of the factory:
 * <p>
 * <code>
 * InputFactory factory = InputFactory.INSTANCE;<br>
 * Chart chart = factory.createChart();<br>
 * chart.setType("line");<br>
 * <br>
 * // add configuration node <br>
 * Configuration configuration = factory.createConfiguration(chart);<br>
 * chart.setConfiguration(configuration);<br>
 * </code>
 * <!-- end-user-doc -->
 * @generated
 */
public interface InputFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	InputFactory INSTANCE = new org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputFactoryImpl();


	/**
	 * Returns a new object of class '<em>Accessibility</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Accessibility</em>'.
	 * @generated
	 */
	Accessibility createAccessibility(Chart chart);

	/**
	 * Returns a new object of class '<em>Unit Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Unit Definition</em>'.
	 * @generated
	 */
	UnitDefinition createUnitDefinition(Chart chart);

	/**
	 * Returns a new object of class '<em>Marker Line</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Marker Line</em>'.
	 * @generated
	 */
	MarkerLine createMarkerLine(Chart chart);

	/**
	 * Returns a new object of class '<em>Marker Region</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Marker Region</em>'.
	 * @generated
	 */
	MarkerRegion createMarkerRegion(Chart chart);

	/**
	 * Returns a new object of class '<em>Number Format</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Number Format</em>'.
	 * @generated
	 */
	NumberFormat createNumberFormat(Chart chart);

	/**
	 * Returns a new object of class '<em>Date Format</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Date Format</em>'.
	 * @generated
	 */
	DateFormat createDateFormat(Chart chart);

	/**
	 * Returns a new object of class '<em>Event Handler</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Event Handler</em>'.
	 * @generated
	 */
	EventHandler createEventHandler(Chart chart);

	/**
	 * Returns a new object of class '<em>Tooltip</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Tooltip</em>'.
	 * @generated
	 */
	Tooltip createTooltip(Chart chart);

	/**
	 * Returns a new object of class '<em>Axis Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Axis Definition</em>'.
	 * @generated
	 */
	AxisDefinition createAxisDefinition(Chart chart);

	/**
	 * Returns a new object of class '<em>Data Set Associations</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Data Set Associations</em>'.
	 * @generated
	 */
	DataSetAssociations createDataSetAssociations(Chart chart);

	/**
	 * Returns a new object of class '<em>Dependent Axis Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Dependent Axis Definition</em>'.
	 * @generated
	 */
	DependentAxisDefinition createDependentAxisDefinition(Chart chart);

	/**
	 * Returns a new object of class '<em>Axes</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Axes</em>'.
	 * @generated
	 */
	Axes createAxes(Chart chart);

	/**
	 * Returns a new object of class '<em>Category</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Category</em>'.
	 * @generated
	 */
	Category createCategory(Chart chart);

	/**
	 * Returns a new object of class '<em>Categories</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Categories</em>'.
	 * @generated
	 */
	Categories createCategories(Chart chart);

	/**
	 * Returns a new object of class '<em>Categorical Data</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Categorical Data</em>'.
	 * @generated
	 */
	CategoricalData createCategoricalData(Chart chart);

	/**
	 * Returns a new object of class '<em>Coordinates</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Coordinates</em>'.
	 * @generated
	 */
	Coordinates createCoordinates(Chart chart);

	/**
	 * Returns a new object of class '<em>Data Set</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Data Set</em>'.
	 * @generated
	 */
	DataSet createDataSet(Chart chart);

	/**
	 * Returns a new object of class '<em>Data Sets</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Data Sets</em>'.
	 * @generated
	 */
	DataSets createDataSets(Chart chart);

	/**
	 * Returns a new object of class '<em>Data</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Data</em>'.
	 * @generated
	 */
	Data createData(Chart chart);

	/**
	 * Returns a new object of class '<em>Internationalization</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Internationalization</em>'.
	 * @generated
	 */
	Internationalization createInternationalization(Chart chart);

	/**
	 * Returns a new object of class '<em>Size</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Size</em>'.
	 * @generated
	 */
	Size createSize(Chart chart);

	/**
	 * Returns a new object of class '<em>Title Bar</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Title Bar</em>'.
	 * @generated
	 */
	TitleBar createTitleBar(Chart chart);

	/**
	 * Returns a new object of class '<em>Data Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Data Value</em>'.
	 * @generated
	 */
	DataValue createDataValue(Chart chart);

	/**
	 * Returns a new object of class '<em>Legend</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Legend</em>'.
	 * @generated
	 */
	Legend createLegend(Chart chart);

	/**
	 * Returns a new object of class '<em>Timestamp</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Timestamp</em>'.
	 * @generated
	 */
	Timestamp createTimestamp(Chart chart);

	/**
	 * Returns a new object of class '<em>Chart Area</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Chart Area</em>'.
	 * @generated
	 */
	ChartArea createChartArea(Chart chart);

	/**
	 * Returns a new object of class '<em>Plot Area</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Plot Area</em>'.
	 * @generated
	 */
	PlotArea createPlotArea(Chart chart);

	/**
	 * Returns a new object of class '<em>Shape</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Shape</em>'.
	 * @generated
	 */
	Shape createShape(Chart chart);

	/**
	 * Returns a new object of class '<em>Shapes</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Shapes</em>'.
	 * @generated
	 */
	Shapes createShapes(Chart chart);

	/**
	 * Returns a new object of class '<em>Data Set Color</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Data Set Color</em>'.
	 * @generated
	 */
	DataSetColor createDataSetColor(Chart chart);

	/**
	 * Returns a new object of class '<em>Palettes</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Palettes</em>'.
	 * @generated
	 */
	Palettes createPalettes(Chart chart);

	/**
	 * Returns a new object of class '<em>Preferences</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Preferences</em>'.
	 * @generated
	 */
	Preferences createPreferences(Chart chart);

	/**
	 * Returns a new object of class '<em>Ecmascript</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Ecmascript</em>'.
	 * @generated
	 */
	Ecmascript createEcmascript(Chart chart);

	/**
	 * Returns a new object of class '<em>Scripts</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Scripts</em>'.
	 * @generated
	 */
	Scripts createScripts(Chart chart);

	/**
	 * Returns a new object of class '<em>Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param chart The chart object associated with the new object.
	 * @return a new object of class '<em>Configuration</em>'.
	 * @generated
	 */
	Configuration createConfiguration(Chart chart);

	/**
	 * Returns a new object of class '<em>Chart</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Chart</em>'.
	 * @generated
	 */
	Chart createChart();

} //InputFactory
