/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGAccessibilityImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGAccessibilityImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;

import org.eclipse.tptp.platform.report.core.internal.DAccessibilityDesc;
import org.eclipse.tptp.platform.report.core.internal.DAccessibilityTitle;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Accessibility</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAccessibilityImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAccessibilityImpl#getTitle <em>Title</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGAccessibilityImpl extends SVGInputBase implements Accessibility {
	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getTitle() <em>Title</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTitle()
	 * @generated
	 * @ordered
	 */
	protected static final String TITLE_EDEFAULT = null;
	
	protected String descProperty = null;
	
	protected String titleProperty = null;

	protected DAccessibilityTitle accessibilityTitle = null;
	protected DAccessibilityDesc accessibilityDesc = null;
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGAccessibilityImpl() {
		super();
	}

	public SVGAccessibilityImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null, null);
	}

	public SVGAccessibilityImpl(Chart chart, DGraphic dgraphic, String titleProperty, String descProperty) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.descProperty = descProperty;
		this.titleProperty = titleProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return descProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		descProperty = newDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTitle() {
		return titleProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTitle(String newTitle) {
		titleProperty = newTitle;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (description: ");
		result.append(getDescription());
		result.append(", title: ");
		result.append(getTitle());
		result.append(')');
		return result.toString();
	}

	public DAccessibilityTitle getDAccessibilityTitle() {
		if (accessibilityTitle == null)
			accessibilityTitle = new DAccessibilityTitle(titleProperty);
		return accessibilityTitle;
	}
	
	public DAccessibilityDesc getDAccessibilityDesc() {
		if (accessibilityDesc == null)
			accessibilityDesc = new DAccessibilityDesc(descProperty);
		return accessibilityDesc;
	}
	
} //AccessibilityImpl
