/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGAxesImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGAxesImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DependentAxisDefinition;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Axes</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxesImpl#getIndependentAxis <em>Independent Axis</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxesImpl#getPrimaryDependentAxis <em>Primary Dependent Axis</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxesImpl#getSecondaryDependentAxis <em>Secondary Dependent Axis</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGAxesImpl extends SVGInputBase implements Axes {
	/**
	 * The cached value of the '{@link #getIndependentAxis() <em>Independent Axis</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIndependentAxis()
	 * @generated
	 * @ordered
	 */
	protected AxisDefinition independentAxis = null;

	/**
	 * The cached value of the '{@link #getPrimaryDependentAxis() <em>Primary Dependent Axis</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrimaryDependentAxis()
	 * @generated
	 * @ordered
	 */
	protected AxisDefinition primaryDependentAxis = null;

	/**
	 * The cached value of the '{@link #getSecondaryDependentAxis() <em>Secondary Dependent Axis</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSecondaryDependentAxis()
	 * @generated
	 * @ordered
	 */
	protected DependentAxisDefinition secondaryDependentAxis = null;

	public static final String PRIMARY_DEPENDENT_AXIS_ID = "y";
	public static final String SECONDARY_DEPENDENT_AXIS_ID = "y2";
	public static final String INDEPENDENT_AXIS_ID = "x";
	
	protected DAxis indepAxis = null;
	protected DAxis priDepAxis = null;
	protected DAxis secDepAxis = null;
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGAxesImpl() {
		super();
	}

	public SVGAxesImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGAxesImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AxisDefinition getIndependentAxis() {
		if (independentAxis == null && _dgraphic != null) {
		    for (IDItem item=_dgraphic.getFirstChild();item!=null; item=item.getNext()) {
				if (item instanceof DAxis){
					if (((DAxis)item).getName().equals(INDEPENDENT_AXIS_ID))
					independentAxis = new SVGAxisDefinitionImpl(_chart, _dgraphic, (DAxis)item);
				}
			}
		}
		return independentAxis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIndependentAxis(AxisDefinition newIndependentAxis) {
		independentAxis = newIndependentAxis;
	}

	// function for assignment
	public void assignIndependentAxis(AxisDefinition source) {
		indepAxis = new DAxis(INDEPENDENT_AXIS_ID);
		_dgraphic.addChild(indepAxis);
		independentAxis = new SVGAxisDefinitionImpl(_chart, _dgraphic, indepAxis);
		if (source != null)
			((SVGAxisDefinitionImpl) independentAxis).assign(source);
		indepAxis.setName("x");
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AxisDefinition getPrimaryDependentAxis() {
		if (primaryDependentAxis == null && _dgraphic != null) {
		    for (IDItem item=_dgraphic.getFirstChild(); item!=null; item=item.getNext()) {
				if (item instanceof DAxis){
					if (((DAxis)item).getName().equals(PRIMARY_DEPENDENT_AXIS_ID))
						primaryDependentAxis = new SVGDependentAxisDefinitionImpl(_chart, _dgraphic, (DAxis)item, "y");
				}
			}
		}
		return primaryDependentAxis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPrimaryDependentAxis(AxisDefinition newPrimaryDependentAxis) {
		primaryDependentAxis = newPrimaryDependentAxis;
	}

	// function for assignment
	public void assignPrimaryDependentAxis(AxisDefinition source) {
		priDepAxis = new DAxis(PRIMARY_DEPENDENT_AXIS_ID);
		_dgraphic.addChild(priDepAxis);
		primaryDependentAxis = new SVGDependentAxisDefinitionImpl(_chart, _dgraphic, priDepAxis, "y");
		if (source != null)
			((SVGDependentAxisDefinitionImpl) primaryDependentAxis).assign(source);
		priDepAxis.setName("y");
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DependentAxisDefinition getSecondaryDependentAxis() {
		if (secondaryDependentAxis == null && _dgraphic != null) {
		    for (IDItem item=_dgraphic.getFirstChild(); item!=null; item=item.getNext()) {
				if (item instanceof DAxis){
					if (((DAxis)item).getName().equals(SECONDARY_DEPENDENT_AXIS_ID))
						secondaryDependentAxis = new SVGDependentAxisDefinitionImpl(_chart, _dgraphic, (DAxis)item, "y2");
				}
			}
		}		
		return secondaryDependentAxis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSecondaryDependentAxis(DependentAxisDefinition newSecondaryDependentAxis) {
		secondaryDependentAxis = newSecondaryDependentAxis;
	}

	// function for assignment
	public void assignSecondaryDependentAxis(DependentAxisDefinition source) {
		secDepAxis = new DAxis(SECONDARY_DEPENDENT_AXIS_ID);
		_dgraphic.addChild(secDepAxis);
		secondaryDependentAxis = new SVGDependentAxisDefinitionImpl(_chart, _dgraphic, secDepAxis, "y2");
		if (source != null)
			((SVGDependentAxisDefinitionImpl) secondaryDependentAxis).assign(source);
		secDepAxis.setName("y2");
	}
	
	// function for model construction
	public DAxis getDIndepAxis() {
		return indepAxis;
	}
	
	// function for model construction
	public DAxis getDPriDepAxis() {
		return priDepAxis;
	}
	// function for model construction
	public DAxis getDSecDepAxis() {
		return secDepAxis;
	}
	
} //AxesImpl
