/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGAxisDefinitionImpl.java,v 1.4 2005/12/16 09:47:08 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGAxisDefinitionImpl.java,v 1.4 2005/12/16 09:47:08 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CustomFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DateFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.DMarkerRegion;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Axis Definition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getLabelRotation <em>Label Rotation</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getMax <em>Max</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getMin <em>Min</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getScale <em>Scale</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getMajorUnit <em>Major Unit</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getMinorUnit <em>Minor Unit</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getMarkerLine <em>Marker Line</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getMarkerRegion <em>Marker Region</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getNumberFormat <em>Number Format</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getDateFormat <em>Date Format</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getAccessibility <em>Accessibility</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getEventHandler <em>Event Handler</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl#getTooltip <em>Tooltip</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGAxisDefinitionImpl extends SVGInputBase implements AxisDefinition {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getLabelRotation() <em>Label Rotation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabelRotation()
	 * @generated
	 * @ordered
	 */
	protected static final double LABEL_ROTATION_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getLabelRotation() <em>Label Rotation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabelRotation()
	 * @generated
	 * @ordered
	 */
	protected double labelRotation = LABEL_ROTATION_EDEFAULT;

	/**
	 * This is true if the Label Rotation attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean labelRotationESet = false;

	/**
	 * The default value of the '{@link #getMax() <em>Max</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMax()
	 * @generated
	 * @ordered
	 */
	protected static final double MAX_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getMax() <em>Max</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMax()
	 * @generated
	 * @ordered
	 */
	protected double max = MAX_EDEFAULT;

	/**
	 * This is true if the Max attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean maxESet = false;

	/**
	 * The default value of the '{@link #getMin() <em>Min</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMin()
	 * @generated
	 * @ordered
	 */
	protected static final double MIN_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getMin() <em>Min</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMin()
	 * @generated
	 * @ordered
	 */
	protected double min = MIN_EDEFAULT;

	/**
	 * This is true if the Min attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean minESet = false;

	/**
	 * The default value of the '{@link #getScale() <em>Scale</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScale()
	 * @generated
	 * @ordered
	 */
	protected static final String SCALE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getScale() <em>Scale</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScale()
	 * @generated
	 * @ordered
	 */
	protected String scale = SCALE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMajorUnit() <em>Major Unit</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMajorUnit()
	 * @generated
	 * @ordered
	 */
	protected UnitDefinition majorUnit = null;

	/**
	 * The cached value of the '{@link #getMinorUnit() <em>Minor Unit</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMinorUnit()
	 * @generated
	 * @ordered
	 */
	protected UnitDefinition minorUnit = null;

	/**
	 * The cached value of the '{@link #getMarkerLine() <em>Marker Line</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMarkerLine()
	 * @generated
	 * @ordered
	 */
	protected List markerLine = null;

	/**
	 * The cached value of the '{@link #getMarkerRegion() <em>Marker Region</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMarkerRegion()
	 * @generated
	 * @ordered
	 */
	protected List markerRegion = null;

	/**
	 * The cached value of the '{@link #getNumberFormat() <em>Number Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberFormat()
	 * @generated
	 * @ordered
	 */
	protected NumberFormat numberFormat = null;

	/**
	 * The cached value of the '{@link #getDateFormat() <em>Date Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDateFormat()
	 * @generated
	 * @ordered
	 */
	protected DateFormat dateFormat = null;

	/**
	 * The cached value of the '{@link #getCustomFormat() <em>Custom Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCustomFormat()
	 * @generated
	 * @ordered
	 */
	protected CustomFormat customFormat = null;
	/**
	 * The cached value of the '{@link #getAccessibility() <em>Accessibility</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessibility()
	 * @generated
	 * @ordered
	 */
	protected Accessibility accessibility = null;

	/**
	 * The cached value of the '{@link #getEventHandler() <em>Event Handler</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventHandler()
	 * @generated
	 * @ordered
	 */
	protected List eventHandler = null;

	/**
	 * The cached value of the '{@link #getTooltip() <em>Tooltip</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTooltip()
	 * @generated
	 * @ordered
	 */
	protected Tooltip tooltip = null;
	
	protected DAxis axis;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGAxisDefinitionImpl() {
		super();
	}

	public SVGAxisDefinitionImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null);
	}

	public SVGAxisDefinitionImpl(Chart chart, DGraphic dgraphic, DAxis axis) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.axis = axis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return axis.getName();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		axis.setName(newId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLabel() {
		return axis.getTitle();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabel(String newLabel) {
		axis.setTitle(newLabel);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getLabelRotation() {
		if (axis.getProperties().get(DAxis.P_LABEL_ROTATION) != null)
			labelRotationESet = true;
		String rotationId = axis.getProperties().get(DAxis.P_LABEL_ROTATION, DAxis.S_ZERO_DEGREE);
		if (rotationId.equals(DAxis.S_PLUS_NINTY_DEGREE)) return 90;
		if (rotationId.equals(DAxis.S_MINUS_NINTY_DEGREE)) return -90;
		return 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabelRotation(double newLabelRotation) {
        axis.getProperties().store(DAxis.P_LABEL_ROTATION, newLabelRotation);
		labelRotationESet = true;
	
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetLabelRotation() {
		labelRotationESet = false;
		axis.getProperties().remove(DAxis.P_LABEL_ROTATION);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetLabelRotation() {
		if (labelRotationESet == false) {
			getLabelRotation();
		}
		return labelRotationESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getMax() {
		if (axis.getProperties().get(DAxis.P_MAX) != null)
			maxESet = true;
        return axis.getProperties().get(DAxis.P_MAX, MAX_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMax(double newMax) {
        axis.getProperties().store(DAxis.P_MAX, newMax);
		maxESet = true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetMax() {
		maxESet = false;
        axis.getProperties().remove(DAxis.P_MAX);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetMax() {
		if (maxESet == false) {
			getMax();
		}
		return maxESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getMin() {
		if (axis.getProperties().get(DAxis.P_MIN) != null)
			minESet = true;
        return axis.getProperties().get(DAxis.P_MIN, MIN_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMin(double newMin) {
        axis.getProperties().store(DAxis.P_MIN, newMin);
		minESet = true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetMin() {
		minESet = false;
        axis.getProperties().remove(DAxis.P_MIN);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetMin() {
		if (minESet == false) {
			getMin();
		}
		return minESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getScale() {
		if ((axis.getScaleType() != null) && (axis.getScaleType().equals(DAxis.S_LOG)))
			return "log";
		return "linear";
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setScale(String newScale) {
		axis.setScaleType(newScale);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnitDefinition getMajorUnit() {
		if (majorUnit == null && axis != null && _dgraphic != null) {
			majorUnit = new SVGUnitDefinitionImpl(_chart, _dgraphic, axis, DAxis.P_MAJUNIT_SHOWTICK, DAxis.P_MAJUNIT_SHOWGRID, DAxis.P_MAJUNIT_VALUE);					
		}
		return majorUnit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMajorUnit(UnitDefinition newMajorUnit) {
		majorUnit = newMajorUnit;
	}

	// function for assignment
	public void assignMajorUnit(UnitDefinition source) {
		majorUnit = new SVGUnitDefinitionImpl(_chart, _dgraphic, axis, DAxis.P_MAJUNIT_SHOWTICK, DAxis.P_MAJUNIT_SHOWGRID, DAxis.P_MAJUNIT_VALUE);
		((SVGUnitDefinitionImpl) majorUnit).assign(source);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnitDefinition getMinorUnit() {
		if (minorUnit == null && _dgraphic != null) {
			minorUnit = new SVGUnitDefinitionImpl(_chart, _dgraphic, axis, DAxis.P_MINUNIT_SHOWTICK, DAxis.P_MINUNIT_SHOWGRID, DAxis.P_MINUNIT_VALUE);					
		}
		return minorUnit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMinorUnit(UnitDefinition newMinorUnit) {
		minorUnit = newMinorUnit;
	}

	// function for assignment
	public void assignMinorUnit(UnitDefinition source) {
		minorUnit = new SVGUnitDefinitionImpl(_chart, _dgraphic, axis, DAxis.P_MINUNIT_SHOWTICK, DAxis.P_MINUNIT_SHOWGRID, DAxis.P_MINUNIT_VALUE);
		((SVGUnitDefinitionImpl) minorUnit).assign(source);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getMarkerLine() {
		if (markerLine == null) {
			if (axis != null) {				
				List dgraphicList = (List)axis.getChildrenOfClass(DMarkerLine.class);
				markerLine = new ArrayList();
				for (int i = 0; i < dgraphicList.size(); ++i) {
					markerLine.add(new SVGMarkerLineImpl(_chart, _dgraphic, (DMarkerLine)dgraphicList.get(i)));
				}
			} else {
				markerLine = new ArrayList();
			}
		}
		return markerLine;
	}

	// function for assignment
	public void setMarkerLine(List newMarkerLine) {
		markerLine = newMarkerLine;
		for (int i = 0; i < newMarkerLine.size(); i++) {
			IDItem markerline = ((SVGMarkerLineImpl) newMarkerLine.get(i)).getDMarkerLine();
			axis.addChild(markerline);
		}
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getMarkerRegion() {
		if (markerRegion == null) {
			if (_dgraphic != null) {
				List dgraphicList = (List)axis.getChildrenOfClass(DMarkerRegion.class);
				markerRegion = new ArrayList();
				for (int i = 0; i < dgraphicList.size(); ++i) {
					markerRegion.add(new SVGMarkerRegionImpl(_chart, _dgraphic, (DMarkerRegion)dgraphicList.get(i)));
				}

			} else {
				markerRegion = new ArrayList();
			}
		}
		return markerRegion;
	}

	// function for assignment
	public void setMarkerRegion(List newMarkerRegion) {
		markerRegion = newMarkerRegion;
		for (int i = 0; i < newMarkerRegion.size(); i++) {
			IDItem markerregion = ((SVGMarkerRegionImpl) newMarkerRegion.get(i)).getDMarkerRegion();
			axis.addChild(markerregion);
		}
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NumberFormat getNumberFormat() {
		String type = (String) axis.getProperties().get(DAxis.P_LABEL_FORMATTYPE);
		if (numberFormat == null && _dgraphic != null && type != null) {
			if (type.equals("number"))
				numberFormat = new SVGNumberFormatImpl(_chart, _dgraphic, (String)axis.getProperties().get(DAxis.P_LABEL_FORMAT));					
		}
		return numberFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNumberFormat(NumberFormat newNumberFormat) {
		numberFormat = newNumberFormat;
		axis.getProperties().store(DAxis.P_LABEL_FORMAT, numberFormat.getPattern());					
		axis.getProperties().store(DAxis.P_LABEL_FORMATTYPE, "number");					
	}
	
	// function for assignment
	public void assignNumberFormat(NumberFormat source) {
		numberFormat = new SVGNumberFormatImpl(_chart, _dgraphic, SVGNumberFormatImpl.PATTERN_EDEFAULT);
		((SVGNumberFormatImpl) numberFormat).assign(source);
		axis.getProperties().store(DAxis.P_LABEL_FORMAT, numberFormat.getPattern());					
		axis.getProperties().store(DAxis.P_LABEL_FORMATTYPE, "number");					
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DateFormat getDateFormat() {
		String type = (String) axis.getProperties().get(DAxis.P_LABEL_FORMATTYPE);
		if (dateFormat == null && _dgraphic != null && type != null) {
			if (type.equals("date"))
				dateFormat = new SVGDateFormatImpl(_chart, _dgraphic, (String)axis.getProperties().get(DAxis.P_LABEL_FORMAT));					
		}
		return dateFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDateFormat(DateFormat newDateFormat) {
		dateFormat = newDateFormat;
		axis.getProperties().store(DAxis.P_LABEL_FORMAT, dateFormat.getPattern());					
		axis.getProperties().store(DAxis.P_LABEL_FORMATTYPE, "date");					
		
	}

	// function for assignment
	public void assignDateFormat(DateFormat source) {
		dateFormat = new SVGDateFormatImpl(_chart, _dgraphic, SVGDateFormatImpl.PATTERN_EDEFAULT);
		((SVGDateFormatImpl) dateFormat).assign(source);
		axis.getProperties().store(DAxis.P_LABEL_FORMAT, dateFormat.getPattern());					
		axis.getProperties().store(DAxis.P_LABEL_FORMATTYPE, "date");					
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Accessibility getAccessibility() {
		if (accessibility == null) {
			accessibility = getAccessibility(axis);
		}
		return accessibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccessibility(Accessibility newAccessibility) {
		accessibility = newAccessibility;
	}
	
	// function for assignment
	public void assignAccessibility(Accessibility source) {
		accessibility = new SVGAccessibilityImpl(_chart, _dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
		((SVGAccessibilityImpl) accessibility).assign(source);
		super.constructAccessibilityModel(accessibility, axis);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getEventHandler() {
		if (eventHandler == null) {
			eventHandler = getEventHandler(axis);
		}
		return eventHandler;
	}

	// function for assignment
	public void setEventHandler(List newEventHandler) {
		eventHandler = newEventHandler;
		super.constructEventHandlerModel(eventHandler, axis);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Tooltip getTooltip() {
		if (tooltip == null && _dgraphic != null) {
			if (axis.getTooltip() != null)
				tooltip = new SVGTooltipImpl(_chart, _dgraphic, axis.getTooltip());					
		}
		return tooltip;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTooltip(Tooltip newTooltip) {
		tooltip = newTooltip;
		axis.setTooltip(newTooltip.getLabel());
	}

	// function for assignment
	public void assignTooltip(Tooltip source) {
		tooltip = new SVGTooltipImpl(_chart, _dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
		((SVGTooltipImpl) tooltip).assign(source);
		axis.setTooltip(tooltip.getLabel());
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(getId());
		result.append(", label: ");
		result.append(getLabel());
		result.append(", max: ");
		if (maxESet) result.append(max); else result.append("<unset>");
		result.append(", min: ");
		if (minESet) result.append(min); else result.append("<unset>");
		result.append(", scale: ");
		result.append(scale);
		result.append(')');
		return result.toString();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition#getCustomFormat()
	 */
	public CustomFormat getCustomFormat() {
		String type = (String) axis.getProperties().get(DAxis.P_LABEL_FORMATTYPE);
		if (customFormat == null && _dgraphic != null && type != null) {
			if (!type.equals("date") && !type.equals("number"))
				customFormat = new SVGCustomFormatImpl(_chart, _dgraphic, (String)axis.getProperties().get(DAxis.P_LABEL_FORMAT), (String)axis.getProperties().get(DAxis.P_LABEL_FORMATTYPE));					
		}
		return customFormat;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition#setCustomFormat(org.eclipse.tptp.platform.report.chart.svg.internal.input.CustomFormat)
	 */
	public void setCustomFormat(CustomFormat newCustomFormat) {
		customFormat = newCustomFormat;
		axis.getProperties().store(DAxis.P_LABEL_FORMAT, customFormat.getPattern());					
		axis.getProperties().store(DAxis.P_LABEL_FORMATTYPE, customFormat.getFormatClass());					
	}
	
	// function for assignment
	public void assignCustomFormat(CustomFormat source) {
		customFormat = new SVGCustomFormatImpl(_chart, _dgraphic, SVGCustomFormatImpl.PATTERN_EDEFAULT, SVGCustomFormatImpl.FORMAT_CLASS_EDEFAULT);	
		((SVGCustomFormatImpl) customFormat).assign(source);
		axis.getProperties().store(DAxis.P_LABEL_FORMAT, customFormat.getPattern());					
		axis.getProperties().store(DAxis.P_LABEL_FORMATTYPE, customFormat.getFormatClass());					
	}
} //AxisDefinitionImpl
