/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGCategoriesImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGCategoriesImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Categories</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCategoriesImpl#getCategory <em>Category</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGCategoriesImpl extends SVGInputBase implements Categories {
	/**
	 * The cached value of the '{@link #getCategory() <em>Category</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCategory()
	 * @generated
	 * @ordered
	 */
	protected List category = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGCategoriesImpl() {
		super();
	}

	public SVGCategoriesImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGCategoriesImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getCategory() {
		ArrayList processedCat = new ArrayList();
		if (category == null) {
			if (_dgraphic != null) {
				category = new ArrayList();
				for (IDItem item=_dgraphic.getFirstChild(); item!=null; item =item.getNext())
				{
				    if ((item instanceof DAxis)) {
						
				        for (IDItem itemCat=item.getFirstChild(); itemCat!=null; itemCat =itemCat.getNext())
				        {
							if (itemCat instanceof DCategory) {
								if (!processedCat.contains(itemCat)){
									processedCat.add(itemCat);
									category.add(new SVGCategoryImpl(_chart, _dgraphic,	(DCategory)itemCat));
								}
							}
						}
					}
				}
			} else {
				category = new ArrayList();
			}
		}
		return category;
	}

	// function for assignment
	public void setCategory(List newCategory) {
		category = newCategory;
		
		// create new Axes if independent and primary dependent axis is null
		if (((SVGAxesImpl) _chart.getConfiguration().getAxes()).getDIndepAxis() == null) 
			((SVGAxesImpl) _chart.getConfiguration().getAxes()).assignIndependentAxis(null);
		if (((SVGAxesImpl) _chart.getConfiguration().getAxes()).getDPriDepAxis() == null) 
			((SVGAxesImpl) _chart.getConfiguration().getAxes()).assignPrimaryDependentAxis(null);
		
		DAxis indepAxis = ((SVGAxesImpl) _chart.getConfiguration().getAxes()).getDIndepAxis();
		
		for (int i = 0; i < category.size(); i++) {
			SVGCategoryImpl catObj = (SVGCategoryImpl) category.get(i);
			indepAxis.addChild(catObj.getDCategory());
		}
	}
	
} //CategoriesImpl
