/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGCategoryImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGCategoryImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;

import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Category</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCategoryImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCategoryImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCategoryImpl#getAccessibility <em>Accessibility</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCategoryImpl#getEventHandler <em>Event Handler</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCategoryImpl#getTooltip <em>Tooltip</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGCategoryImpl extends SVGInputBase implements Category {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = null;


	/**
	 * The cached value of the '{@link #getAccessibility() <em>Accessibility</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessibility()
	 * @generated
	 * @ordered
	 */
	protected Accessibility accessibility = null;

	/**
	 * The cached value of the '{@link #getEventHandler() <em>Event Handler</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventHandler()
	 * @generated
	 * @ordered
	 */
	protected List eventHandler = null;

	/**
	 * The cached value of the '{@link #getTooltip() <em>Tooltip</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTooltip()
	 * @generated
	 * @ordered
	 */
	protected Tooltip tooltip = null;
	
	protected DCategory category;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGCategoryImpl() {
		super();
	}

	public SVGCategoryImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null);
	}

	public SVGCategoryImpl(Chart chart, DGraphic dgraphic, DCategory category) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.category = category;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Accessibility getAccessibility() {
		if (accessibility == null) {
			accessibility = getAccessibility(category);
		}
		return accessibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccessibility(Accessibility newAccessibility) {
		accessibility = newAccessibility;
	}
	
	// function for assignment
	public void assignAccessibility(Accessibility source) {
		accessibility = new SVGAccessibilityImpl(_chart, _dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
		((SVGAccessibilityImpl) accessibility).assign(source);
		super.constructAccessibilityModel(accessibility, category);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getEventHandler() {
		if (eventHandler == null) {
			eventHandler = getEventHandler(category);
		}
		return eventHandler;
	}

	// function for assignment
	public void setEventHandler(List newEventHandler) {
		eventHandler = newEventHandler;
		super.constructEventHandlerModel(eventHandler, category);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(getId());
		result.append(", label: ");
		result.append(getLabel());
		result.append(')');
		return result.toString();
	}

	/**
	 * @return
	 */
	public String getId() {
		return category.getId();
	}
	/**
	 * @return
	 */
	public String getLabel() {
		return category.getLabel();
	}
	/**
	 * @return
	 */
	public Tooltip getTooltip() {
		if (tooltip == null){
			if ( category.getTooltip() != null)
				tooltip = new SVGTooltipImpl(_chart, _dgraphic, category.getTooltip());
		}
		return tooltip;
	}
	/**
	 * @param id
	 */
	public void setId(String id) {
		category.setId(id);
	}
	/**
	 * @param label
	 */
	public void setLabel(String label) {
		category.setLabel(label);
	}
	/**
	 * @param tooltip
	 */
	public void setTooltip(Tooltip tooltip) {
		this.tooltip = tooltip;
		category.setTooltip(tooltip.getLabel());
	}
	
	// function for assignment
	public void assignTooltip(Tooltip source) {
		tooltip = new SVGTooltipImpl(_chart, _dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
		((SVGTooltipImpl) tooltip).assign(source);
		category.setTooltip(tooltip.getLabel());
	}
	
	public DCategory getDCategory() {
		return category;
	}
} //CategoryImpl
