/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGChartAreaImpl.java,v 1.2 2005/04/06 15:21:41 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGChartAreaImpl.java,v 1.2 2005/04/06 15:21:41 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.ChartArea;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Chart Area</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartAreaImpl#getBackgroundColor <em>Background Color</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartAreaImpl#isBorder <em>Border</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGChartAreaImpl extends SVGInputBase implements ChartArea {
	/**
	 * The default value of the '{@link #getBackgroundColor() <em>Background Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBackgroundColor()
	 * @generated
	 * @ordered
	 */
	protected static final String BACKGROUND_COLOR_EDEFAULT = null;

	/**
	 * The default value of the '{@link #isBorder() <em>Border</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isBorder()
	 * @generated
	 * @ordered
	 */
	protected static final boolean BORDER_EDEFAULT = true;

	/**
	 * This is true if the Border attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean borderESet = false;

	/**
	 * The cached value of the '{@link #getAccessibility() <em>Accessibility</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessibility()
	 * @generated
	 * @ordered
	 */
	protected Accessibility accessibility = null;

	/**
	 * The cached value of the '{@link #getEventHandler() <em>Event Handler</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventHandler()
	 * @generated
	 * @ordered
	 */
	protected List eventHandler = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGChartAreaImpl() {
		super();
	}

	public SVGChartAreaImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGChartAreaImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getBackgroundColor() {
		DColor color = ((DColor)_dgraphic.getProperties().get(DGraphic.P_BACKCOLOR));
		if (color != null)
			return color.serializeToString();
		return BACKGROUND_COLOR_EDEFAULT;        
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBackgroundColor(String newBackgroundColor) {
		if (newBackgroundColor != null && newBackgroundColor != "" && !newBackgroundColor.substring(0, 1).equals("#"))  // if the color name is not "#......"
			newBackgroundColor = convertToHex(newBackgroundColor);
		if (newBackgroundColor == null || newBackgroundColor == "") {	// if not matched, use default color
			_dgraphic.getProperties().remove(DGraphic.P_BACKCOLOR);
			return;
		}
		_dgraphic.getProperties().store(DGraphic.P_BACKCOLOR,newBackgroundColor);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isBorder() {
		if (_dgraphic.getProperties().get(DGraphic.P_SHOW_BORDER) != null)
			borderESet = true;
		return _dgraphic.getProperties().get(DGraphic.P_SHOW_BORDER,BORDER_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBorder(boolean newBorder) {
		_dgraphic.getProperties().store(DGraphic.P_SHOW_BORDER,newBorder);
		borderESet = true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetBorder() {
		borderESet = false;
		_dgraphic.getProperties().remove(DGraphic.P_SHOW_BORDER);

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetBorder() {
		if (borderESet == false) {
			isBorder();
		}
		return borderESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Accessibility getAccessibility() {
		if (accessibility == null) {
			accessibility = getAccessibility(_dgraphic);					
		}
		return accessibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccessibility(Accessibility newAccessibility) {
		accessibility = newAccessibility;
	}

	// function for assignment
	public void assignAccessibility(Accessibility source) {
		accessibility = new SVGAccessibilityImpl(_chart, _dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
		((SVGAccessibilityImpl) accessibility).assign(source);
		super.constructAccessibilityModel(accessibility, _dgraphic);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getEventHandler() {
		if (eventHandler == null) {
			eventHandler = getEventHandler(_dgraphic);					
		}
		return eventHandler;
	}

	// function for assignment
	public void setEventHandler(List newEventHandler) {
		eventHandler = newEventHandler;
		super.constructEventHandlerModel(eventHandler, _dgraphic);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (backgroundColor: ");
		result.append(getBackgroundColor());
		result.append(", border: ");
		if (borderESet) result.append(this.isBorder()); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //ChartAreaImpl
