/* ***********************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGChartImpl.java,v 1.6 2006/02/14 21:23:33 sleeloy Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.HashMap;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.IGraphicTypeConstants;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DColorRegistry;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlError;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Chart</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl#getData <em>Data</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl#getConfiguration <em>Configuration</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGChartImpl extends SVGInputBase implements Chart {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String VERSION_EDEFAULT = "3.0";

	/**
	 * The cached value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected String version = VERSION_EDEFAULT;

	/**
	 * This is true if the Type attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean typeESet = false;

	/**
	 * This is true if the Version attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean versionESet = false;
	
	/**
	 * The cached value of the '{@link #getData() <em>Data</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getData()
	 * @generated
	 * @ordered
	 */
	protected Data data = null;

	/**
	 * The cached value of the '{@link #getConfiguration() <em>Configuration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfiguration()
	 * @generated
	 * @ordered
	 */
	protected Configuration configuration = null;

    /** list of registered factoryies used to create IDItem object from element names */
	private DColorRegistry colors;

	/** current map of IDColor using their id as key. */
	private HashMap colorsId; //
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SVGChartImpl() {
		super();
	}
	
	public SVGChartImpl(DGraphic dgraphic) {
		_dgraphic = dgraphic;
		//migration code for pie charts sometimes 
		if (getType().equals(IGraphicTypeConstants.PIE_CHART) || getType().equals(IGraphicTypeConstants.PIE_CHART3D) ||
			getType().equals(IGraphicTypeConstants.VBAR_CHART3D) || getType().equals(IGraphicTypeConstants.VBAR_CHART) ||
			getType().equals(IGraphicTypeConstants.HBAR_CHART3D) || getType().equals(IGraphicTypeConstants.HBAR_CHART))
			pieMigration(dgraphic);
		else if (getType().equals(IGraphicTypeConstants.HSTACKBAR_CHART) || getType().equals(IGraphicTypeConstants.HSTACKBAR_CHART3D) ||
				getType().equals(IGraphicTypeConstants.VSTACKBAR_CHART) || getType().equals(IGraphicTypeConstants.VSTACKBAR_CHART3D)				)
			stackMigration(dgraphic);
	}
	protected void stackMigration(DGraphic dgraphic){
		boolean hasCategory = false;
		boolean hasAxis = false;
			if (_dgraphic != null) {
			    for (IDItem item=_dgraphic.getFirstChild(); item!=null; item=item.getNext()) {
					if ((item instanceof DAxis)) {
						hasAxis = true;
						for (IDItem itemCat=item.getFirstChild(); itemCat!=null; itemCat=itemCat.getNext()) {
							if (itemCat instanceof DCategory) {
								hasCategory = true;
								break;
							}
						}
						if (hasCategory) break;
					}
				}
				
			//Need to migrate
			if (!hasCategory){
				List curves = _dgraphic.getChildrenOfClass(DCurve.class);
				DAxis yaxis = (DAxis)_dgraphic.getChildOfClass(DAxis.class);
				if (yaxis == null) return;
				yaxis.setName("y");
				DAxis xaxis = new DAxis("x");
				DCurve curve = (DCurve)curves.get(0);
				List points = curve.getChildrenOfClass(DPoint.class);
				String[] cat = new String[points.size()];
				for (int x=0; x< points.size(); x++){
					DPoint point = (DPoint)points.get(x);
					DText text = (DText)point.getChildOfClass(DText.class);
					DCategory category = new DCategory();
					if (text == null) return;
					category.setId(EventTools.getHashCode(text)+"");
					category.setLabel(text.getText());
					xaxis.addChild(category);
					cat[x] = category.getId();
				}
				for (int y= 0; y < curves.size(); y++){
					curve = (DCurve)curves.get(y);
					points = curve.getChildrenOfClass(DPoint.class);
					for (int x=0; x< points.size(); x++){
						DPoint point = (DPoint)points.get(x);
						DCoordObject coordObj = new DCoordObject();
						coordObj.setAxis(xaxis);
						coordObj.setValue(cat[x]);
						point.addChild(coordObj);
						
					}
										
				}
				_dgraphic.addChild(xaxis);
			}
		}
	}

	protected void pieMigration(DGraphic dgraphic){
		boolean hasCategory = false;
		boolean hasAxis = false;
			if (_dgraphic != null) {
			    for (IDItem item=_dgraphic.getFirstChild();item!=null;item=item.getNext()) {
					if ((item instanceof DAxis)) {
						hasAxis = true;
						for (IDItem itemCat=item.getFirstChild(); itemCat!=null; itemCat=itemCat.getNext()) {
							if (itemCat instanceof DCategory) {
								hasCategory = true;
								break;
							}
						}
						if (hasCategory) break;
					}
				}
				
			//Need to migrate
			if (!hasCategory){
				List axes = _dgraphic.getChildrenOfClass(DAxis.class);
				if (axes.size() > 0){
				DAxis xAxis = new DAxis("x");
				_dgraphic.addChild(xAxis);
				for (int y= 0; y < axes.size(); y++){
					DAxis axis  = (DAxis)axes.get(y);
					axis.setName("y");
					for (IDItem itemCat=axis.getFirstChild(); itemCat!=null; itemCat = itemCat.getNext()) {
						if (itemCat instanceof DCurve) {
							DCurve curve = (DCurve)itemCat;
							DPoint point = (DPoint)curve.getChildOfClass(DPoint.class);
							DCoordObject coordObj = new DCoordObject();
							coordObj.setAxis(xAxis);
							coordObj.setValue(curve.getName());
							point.addChild(coordObj);
							DCategory category = new DCategory();
							category.setId(curve.getName());
							category.setLabel(curve.getName());
							xAxis.addChild(category);							
						}
					}
					
				}
				}
			}
		}
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return (String)_dgraphic.getProperties().get(DGraphic.P_ID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		if (newId == null)
			newId = String.valueOf(EventTools.getHashCode(this));
		_dgraphic.getProperties().store(DGraphic.P_ID, newId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {	      
		
		if (!typeESet){
			boolean threeD = false;
			type = _dgraphic.getGraphicType();		
			threeD = _dgraphic.getProperties().get(DGraphic.P_3D, false);
			if (DGraphic.T_HBARS.equals(type)){
				if (threeD)
					type = IGraphicTypeConstants.HBAR_CHART3D;			
				else
					type = IGraphicTypeConstants.HBAR_CHART;			
			}
			else if (DGraphic.T_HISTOGRAM.equals(type)){
				if (threeD)
					type = IGraphicTypeConstants.VBAR_CHART3D;
				else
					type = IGraphicTypeConstants.VBAR_CHART;
			}
			else if (DGraphic.T_STACKBARS.equals(type)){
				if (threeD)
					type = IGraphicTypeConstants.VSTACKBAR_CHART3D;
				else
					type = IGraphicTypeConstants.VSTACKBAR_CHART;
			}
			else if (DGraphic.T_SECTORS3D.equals(type))
				type = IGraphicTypeConstants.PIE_CHART3D;
			else if (DGraphic.T_SECTORS.equals(type)){
				type = IGraphicTypeConstants.PIE_CHART;
			}
			else if (DGraphic.T_METER.equals(type))
				type = IGraphicTypeConstants.METER;
			else if (DGraphic.T_XY.equals(type))
				type = IGraphicTypeConstants.LINE_CHART;
			else if (DGraphic.T_XYZ.equals(type))
				Utilities.assertion(false);
			else if (DGraphic.T_WIREFRAME.equals(type))
				Utilities.assertion(false);
			else if (DGraphic.T_XYZ.equals(type))
				Utilities.assertion(false);
			else if (DGraphic.T_PIE3D.equals(type))
				Utilities.assertion(false);
			else if (DGraphic.T_TORUS3D.equals(type))
				Utilities.assertion(false);
			typeESet = true;
		}
//		   /**
//		    * graphic is a flat histogram using mixed values, means each point having same index from
//		    * curves are rendered together.
//		    * You can apply P_THIN_BAR or/and P_3D property on this graphic type.
//		    */
//		   public static final String T_HISTOGRAM_IM = "T_HISTOGRAM_IM.DGraphic.core.jscrib";
//
//		   /**
//		    * graphic is made of fixed angle sectors but ray depends on points values
//		    */
//		   public static final String T_HISTORS = "T_HISTORS.DGraphic.core.jscrib";


		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		
		type = newType;
		
		if (_dgraphic != null) {
			boolean threeD = false;
			String dGraphicType = null; 
			if (type.equals(IGraphicTypeConstants.HBAR_CHART)){
				dGraphicType = DGraphic.T_HBARS;
			}
			else if (type.equals(IGraphicTypeConstants.HBAR_CHART3D)){
				dGraphicType = DGraphic.T_HBARS;
				_dgraphic.getProperties().store(DGraphic.P_3D, true);
			}
			else if (type.equals(IGraphicTypeConstants.VBAR_CHART)){
				dGraphicType = DGraphic.T_HISTOGRAM;
			}
			else if (type.equals(IGraphicTypeConstants.VBAR_CHART3D)){
				dGraphicType = DGraphic.T_HISTOGRAM;
				_dgraphic.getProperties().store(DGraphic.P_3D, true);
			}
			else if (type.equals(IGraphicTypeConstants.VSTACKBAR_CHART)){
				dGraphicType = DGraphic.T_STACKBARS;
			}
			else if (type.equals(IGraphicTypeConstants.VSTACKBAR_CHART3D)){
				dGraphicType = DGraphic.T_STACKBARS;
				_dgraphic.getProperties().store(DGraphic.P_3D, true);
			}
			else if (type.equals(IGraphicTypeConstants.PIE_CHART3D)){
				dGraphicType = DGraphic.T_SECTORS3D;
			}
			else if (type.equals(IGraphicTypeConstants.PIE_CHART)){
				dGraphicType = DGraphic.T_SECTORS;
			}
			else if (type.equals(IGraphicTypeConstants.METER)){
				dGraphicType = DGraphic.T_METER;
			}
			else if (type.equals(IGraphicTypeConstants.LINE_CHART)){
				dGraphicType = DGraphic.T_XY;
			}
			else
				dGraphicType = type;
			_dgraphic.setGraphicType(dGraphicType);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVersion() {
		// Handle default value
		if (_dgraphic != null) {
			version = _dgraphic.getProperties().get(DGraphic.P_VERSION, VERSION_EDEFAULT);
			if (_dgraphic.getProperties().get(DGraphic.P_VERSION) != null)
				versionESet = true;
		}
		return version;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVersion(String newVersion) {
		version = newVersion;
		versionESet = true;
		
		if (_dgraphic != null) {
			_dgraphic.getProperties().store(DGraphic.P_VERSION, newVersion);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetVersion() {
		versionESet = false;
		version = VERSION_EDEFAULT;
	
		if (_dgraphic != null ) {
			_dgraphic.getProperties().remove(DGraphic.P_VERSION);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetVersion() {
		if (versionESet == false) {
			getVersion();
		}
		return versionESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Data getData() {
		if (data == null && _dgraphic != null) {
			data = new SVGDataImpl(this, _dgraphic);
		}
		return data;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setData(Data newData) {
		data = newData;		
	}

	// function for assignment
	public void assignData(Data source) {
		data = new SVGDataImpl(this, _dgraphic);
		((SVGDataImpl) data).assign(source);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Configuration getConfiguration() {
		if (configuration == null && _dgraphic != null) {
				configuration = new SVGConfigurationImpl(this, _dgraphic);					
		}
		return configuration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfiguration(Configuration newConfiguration) {
		configuration = newConfiguration;		
	}
	
	// function for assignment
	public void assignConfiguration(Configuration source) {
		configuration = new SVGConfigurationImpl(this, _dgraphic);
		((SVGConfigurationImpl) configuration).assign(source);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(getId());
		result.append(", type: ");
		result.append(type);
		result.append(", version: ");
		if (versionESet) result.append(version); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

	// need to specify the order of assigment
	public void assign(Chart source) {
		setId(source.getId());
		setType(source.getType());
		if (source.isSetVersion())
			setVersion(source.getVersion());
		if (source.getConfiguration() != null)
			assignConfiguration(source.getConfiguration());
		if (source.getData() != null)
			assignData(source.getData());
	}
	
    public IDColor getColor(String val)
	{   
        DColor color = null;
        if ((val.charAt(0)!='#') && (val.length()<7))
            throw new DXmlError("Bad syntax color ("+val+") while parsing '' tag");
        if (colorsId == null) colorsId = new HashMap();
        color = (DColor)colorsId.get(val);
        if (color==null)
        {
           // color with format #RRGGBBAA
           color = new DColor();
           color.serializeFromString(val);
           if (colors==null)
               colors = new DColorRegistry();
           colors.putColor(color);
           colorsId.put(val, color);
        }
        
        return color;
    }	
} //ChartImpl
