/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGConfigurationImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGConfigurationImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.ChartArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Legend;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Palettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.PlotArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Preferences;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Scripts;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Size;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Timestamp;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.TitleBar;

import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPreferences;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl#getSize <em>Size</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl#getTitleBar <em>Title Bar</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl#getAxes <em>Axes</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl#getLegend <em>Legend</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl#getBackgroundColors <em>Background Colors</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl#getShapes <em>Shapes</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl#getPalettes <em>Palettes</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl#getPreferences <em>Preferences</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGConfigurationImpl extends SVGInputBase implements Configuration {
	/**
	 * The cached value of the '{@link #getInternationalization() <em>Internationalization</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInternationalization()
	 * @generated
	 * @ordered
	 */
	protected Internationalization internationalization = null;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected Size size = null;

	/**
	 * The cached value of the '{@link #getTitleBar() <em>Title Bar</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTitleBar()
	 * @generated
	 * @ordered
	 */
	protected TitleBar titleBar = null;

	/**
	 * The cached value of the '{@link #getAxes() <em>Axes</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAxes()
	 * @generated
	 * @ordered
	 */
	protected Axes axes = null;

	/**
	 * The cached value of the '{@link #getDataValue() <em>DataValue</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataValue()
	 * @generated
	 * @ordered
	 */
	protected DataValue dataValue = null;

	/**
	 * The cached value of the '{@link #getLegend() <em>Legend</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLegend()
	 * @generated
	 * @ordered
	 */
	protected Legend legend = null;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected Timestamp timestamp = null;

	/**
	 * The cached value of the '{@link #getChartArea() <em>Chart Area</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChartArea()
	 * @generated
	 * @ordered
	 */
	protected ChartArea chartArea = null;

	/**
	 * The cached value of the '{@link #getPlotArea() <em>Plot Area</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPlotArea()
	 * @generated
	 * @ordered
	 */
	protected PlotArea plotArea = null;

	/**
	 * The cached value of the '{@link #getShapes() <em>Shapes</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getShapes()
	 * @generated
	 * @ordered
	 */
	protected Shapes shapes = null;

	/**
	 * The cached value of the '{@link #getPalettes() <em>Palettes</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPalettes()
	 * @generated
	 * @ordered
	 */
	protected Palettes palettes = null;

	/**
	 * The cached value of the '{@link #getPreferences() <em>Preferences</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPreferences()
	 * @generated
	 * @ordered
	 */
	protected Preferences preferences = null;

	/**
	 * The cached value of the '{@link #getScripts() <em>Scripts</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScripts()
	 * @generated
	 * @ordered
	 */
	protected Scripts scripts = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGConfigurationImpl() {
		super();
	}

	public SVGConfigurationImpl(SVGChartImpl chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_dgraphic = chart.getDGraphic();
		}
	}

	public SVGConfigurationImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
//		super.initHashTable();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Internationalization getInternationalization() {
		if (internationalization == null && _dgraphic != null) {
			internationalization = new SVGInternationalizationImpl(_chart, _dgraphic);					
		}
		return internationalization;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInternationalization(Internationalization newInternationalization) {
		internationalization = newInternationalization;
	}

	// function for assignment
	public void assignInternationalization(Internationalization source) {
		internationalization = new SVGInternationalizationImpl(_chart, _dgraphic);
		((SVGInternationalizationImpl) internationalization).assign(source);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Size getSize() {
		if (size == null && _dgraphic != null) {
				size = new SVGSizeImpl(_chart, _dgraphic);					
		}
		return size;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSize(Size newSize) {
		size = newSize;

	}

	// function for assignment
	public void assignSize(Size source) {
		size = new SVGSizeImpl(_chart, _dgraphic);
		((SVGSizeImpl) size).assign(source);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TitleBar getTitleBar() {
		if (titleBar == null && _dgraphic != null) {
				titleBar = new SVGTitleBarImpl(_chart, _dgraphic);					
		}
		return titleBar;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTitleBar(TitleBar newTitleBar) {
		titleBar = newTitleBar;
	}

	// function for assignment
	public void assignTitleBar(TitleBar source) {
		titleBar = new SVGTitleBarImpl(_chart, _dgraphic);
		((SVGTitleBarImpl) titleBar).assign(source);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Axes getAxes() {
		if (axes == null && _dgraphic != null) {
				axes = new SVGAxesImpl(_chart, _dgraphic);					
		}
		return axes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAxes(Axes newAxes) {
		axes = newAxes;

	}

	// function for assignment
	public void assignAxes(Axes source) {
		axes = new SVGAxesImpl(_chart, _dgraphic);
		((SVGAxesImpl) axes).assign(source);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Legend getLegend() {
		if (legend == null && _dgraphic != null) {
				legend = new SVGLegendImpl(_chart, _dgraphic);					
		}
		return legend;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLegend(Legend newLegend) {
		legend = newLegend;

	}
	
	// function for assignment
	public void assignLegend(Legend source) {
		legend = new SVGLegendImpl(_chart, _dgraphic);
		((SVGLegendImpl) legend).assign(source);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Timestamp getTimestamp() {
		if (timestamp == null && _dgraphic != null) {
				timestamp = new SVGTimestampImpl(_chart, _dgraphic);					
		}
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimestamp(Timestamp newTimestamp) {
		timestamp = newTimestamp;
	}

	// function for assignment
	public void assignTimestamp(Timestamp source) {
		timestamp = new SVGTimestampImpl(_chart, _dgraphic);
		((SVGTimestampImpl) timestamp).assign(source);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataValue getDataValue() {
		if (dataValue == null && _dgraphic != null) {
				dataValue = new SVGDataValueImpl(_chart, _dgraphic);					
		}
		return dataValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDataValue(DataValue newDataValue) {
		dataValue = newDataValue;
	}
	
	// function for assignment
	public void assignDataValue(DataValue source) {
		dataValue = new SVGDataValueImpl(_chart, _dgraphic);
		((SVGDataValueImpl) dataValue).assign(source);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ChartArea getChartArea() {
		if (chartArea == null && _dgraphic != null) {
				chartArea = new SVGChartAreaImpl(_chart, _dgraphic);					
		}
		return chartArea;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setChartArea(ChartArea newChartArea) {
		chartArea = newChartArea;
	}

	// function for assignment
	public void assignChartArea(ChartArea source) {
		chartArea = new SVGChartAreaImpl(_chart, _dgraphic);
		((SVGChartAreaImpl) chartArea).assign(source);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PlotArea getPlotArea() {
		if (plotArea == null && _dgraphic != null) {
				plotArea = new SVGPlotAreaImpl(_chart, _dgraphic);					
		}
		return plotArea;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPlotArea(PlotArea newPlotArea) {
		plotArea = newPlotArea;
	}

	// function for assignment
	public void assignPlotArea(PlotArea source) {
		plotArea = new SVGPlotAreaImpl(_chart, _dgraphic);
		((SVGPlotAreaImpl) plotArea).assign(source);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Shapes getShapes() {
		if (shapes == null && _dgraphic != null) {
				shapes = new SVGShapesImpl(_chart, _dgraphic);					
		}
		return shapes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShapes(Shapes newShapes) {
		shapes = newShapes;
	}

	// function for assignment
	public void assignShapes(Shapes source) {
		shapes = new SVGShapesImpl(_chart, _dgraphic);
		((SVGShapesImpl) shapes).assign(source);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Palettes getPalettes() {
		if (palettes == null && _dgraphic != null) {
			palettes = new SVGPalettesImpl(_chart, _dgraphic);					
		}
		return palettes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPalettes(Palettes newPalettes) {
		palettes = newPalettes;
	}

	// function for assignment
	public void assignPalettes(Palettes source) {
		palettes = new SVGPalettesImpl(_chart, _dgraphic);
		((SVGPalettesImpl) palettes).assign(source);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Preferences getPreferences() {
		if (preferences == null && _dgraphic != null) {
				DPreferences pref = (DPreferences)_dgraphic.getChildOfClass(DPreferences.class);
				if (pref != null)
					preferences = new SVGPreferencesImpl(_chart, _dgraphic, pref);					
		}
		return preferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPreferences(Preferences newPreferences) {
		preferences = newPreferences;
	}
	
	// function for assignment
	public void assignPreferences(Preferences source) {
		preferences = new SVGPreferencesImpl(_chart, _dgraphic, new DPreferences());
		((SVGPreferencesImpl) preferences).assign(source);
	}
	

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Scripts getScripts() {
		if (scripts == null && _dgraphic != null) {
			scripts = new SVGScriptsImpl(_chart, _dgraphic);					
		}
		return scripts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setScripts(Scripts newScripts) {
		scripts = newScripts;
	}
	
	// function for assignment
	public void assignScripts(Scripts source) {
		scripts = new SVGScriptsImpl(_chart, _dgraphic);
		((SVGScriptsImpl) scripts).assign(source);
	}

} //ConfigurationImpl
