/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGCoordinatesImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGCoordinatesImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Coordinates;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;

import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Coordinates</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCoordinatesImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCoordinatesImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCoordinatesImpl#getValue1 <em>Value1</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCoordinatesImpl#getValue2 <em>Value2</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCoordinatesImpl#getAccessibility <em>Accessibility</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCoordinatesImpl#getEventHandler <em>Event Handler</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCoordinatesImpl#getTooltip <em>Tooltip</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGCoordinatesImpl extends SVGInputBase implements Coordinates {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = "actual";

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * This is true if the Type attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean typeESet = false;

	/**
	 * The default value of the '{@link #getValue1() <em>Value1</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue1()
	 * @generated
	 * @ordered
	 */
	protected static final double VALUE1_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getValue1() <em>Value1</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue1()
	 * @generated
	 * @ordered
	 */
	protected double value1 = VALUE1_EDEFAULT;

	/**
	 * This is true if the Value1 attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean value1ESet = false;

	/**
	 * The default value of the '{@link #getValue2() <em>Value2</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue2()
	 * @generated
	 * @ordered
	 */
	protected static final double VALUE2_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getValue2() <em>Value2</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue2()
	 * @generated
	 * @ordered
	 */
	protected double value2 = VALUE2_EDEFAULT;

	/**
	 * This is true if the Value2 attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean value2ESet = false;

	/**
	 * The cached value of the '{@link #getAccessibility() <em>Accessibility</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessibility()
	 * @generated
	 * @ordered
	 */
	protected Accessibility accessibility = null;

	/**
	 * The cached value of the '{@link #getEventHandler() <em>Event Handler</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventHandler()
	 * @generated
	 * @ordered
	 */
	protected List eventHandler = null;

	/**
	 * The cached value of the '{@link #getTooltip() <em>Tooltip</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTooltip()
	 * @generated
	 * @ordered
	 */
	protected Tooltip tooltip = null;
	protected DPoint point = null;
	protected IDCoord valueCoord = null;
	protected IDCoord valueCoord2 = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGCoordinatesImpl() {
		super();
	}

	public SVGCoordinatesImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null, null, null);
	}

	public SVGCoordinatesImpl(Chart chart, DGraphic dgraphic, DPoint point, IDCoord valueCoord, IDCoord valueCoord2) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.point = point;
		this.valueCoord = valueCoord;
		this.valueCoord2 = valueCoord2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return point.getId();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		point.setId(newId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {
		if (point.getType() != DPoint.DEF_ACTUAL_POINT)
			typeESet = true;
		return point.getType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		point.setType(newType);
		typeESet = true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetType() {
		typeESet = false;
		point.setType(TYPE_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetType() {
		if (typeESet == false) {
			getType();
		}
		return typeESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getValue1() {
		if (valueCoord instanceof DCoord) {
			value1ESet = true;
			return ((DCoord)valueCoord).getValue();
		}
		else if (valueCoord instanceof DCoordObject) {			
			value1ESet = true;
			return Double.parseDouble(((DCoordObject)valueCoord).getValue(null).toString());
		}
		return 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValue1(double newValue1) {
		if (valueCoord instanceof DCoord){
			((DCoord)valueCoord).setValue(newValue1);
			value1ESet = true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetValue1() {
		setValue1(VALUE1_EDEFAULT);
		value1ESet = false;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetValue1() {
		if (value1ESet == false) {
			getValue1();
		}
		return value1ESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getValue2() {
		if (valueCoord2 instanceof DCoord) {
			value2ESet = true;
			return ((DCoord)valueCoord2).getValue();
		}
		else if (valueCoord2 instanceof DCoordObject) {			
			value2ESet = true;
			return Double.parseDouble(((DCoordObject)valueCoord2).getValue(null).toString());
		}
		return 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValue2(double newValue2) {
		value2 = newValue2;
		if (valueCoord instanceof DCoord){
			((DCoord)valueCoord2).setValue(newValue2);
			value2ESet = true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetValue2() {
		setValue2(VALUE2_EDEFAULT);
		value2ESet = false;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetValue2() {
		if (value2ESet == false) {
			getValue2();
		}
		return value2ESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Accessibility getAccessibility() {
		if (accessibility == null) {
			accessibility = getAccessibility(point);				
		}
		return accessibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccessibility(Accessibility newAccessibility) {
		accessibility = newAccessibility;
	}

	// function for assignment
	public void assignAccessibility(Accessibility source) {
		accessibility = new SVGAccessibilityImpl(_chart, _dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
		((SVGAccessibilityImpl) accessibility).assign(source);
		super.constructAccessibilityModel(accessibility, point);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getEventHandler() {
		if (eventHandler == null) {
			eventHandler = getEventHandler(point);
		}
		return eventHandler;

	}
	
	// function for assignment
	public void setEventHandler(List newEventHandler) {
		eventHandler = newEventHandler;
		super.constructEventHandlerModel(eventHandler, point);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Tooltip getTooltip() {
		if (tooltip == null && _dgraphic != null) {
			if (point.getTooltip() != null)
				tooltip = new SVGTooltipImpl(_chart, _dgraphic, point.getTooltip());					
		}
		return tooltip;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTooltip(Tooltip newTooltip) {
		tooltip = newTooltip;
		point.setTooltip(tooltip.getLabel());
	}

	// function for assignment
	public void assignTooltip(Tooltip source) {
		tooltip = new SVGTooltipImpl(_chart, _dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
		((SVGTooltipImpl) tooltip).assign(source);
		point.setTooltip(tooltip.getLabel());
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", type: ");
		if (typeESet) result.append(type); else result.append("<unset>");
		result.append(", value1: ");
		if (value1ESet) result.append(value1); else result.append("<unset>");
		result.append(", value2: ");
		if (value2ESet) result.append(value2); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //CoordinatesImpl
