/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDataImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDataImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;

import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DTimeStamp;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataImpl#getCategories <em>Categories</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataImpl#getDataSets <em>Data Sets</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGDataImpl extends SVGInputBase implements Data {
	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final String TIMESTAMP_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected String timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCategories() <em>Categories</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCategories()
	 * @generated
	 * @ordered
	 */
	protected Categories categories = null;

	/**
	 * The cached value of the '{@link #getDataSets() <em>Data Sets</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSets()
	 * @generated
	 * @ordered
	 */
	protected DataSets dataSets = null;
	
	protected DTimeStamp ts = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGDataImpl() {
		super();
	}

	public SVGDataImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGDataImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
		ts = (DTimeStamp)_dgraphic.getChildOfClass(DTimeStamp.class);
		if (ts == null){
			ts = new DTimeStamp();
		}
		if (categories == null && _dgraphic != null) {
			categories = new SVGCategoriesImpl(_chart, _dgraphic);		
			if ((categories.getCategory() == null) || (categories.getCategory().size() == 0)) categories = null;
		}		

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTimestamp() {
		if (ts.getValue() == null) return null;
		return ts.getValue();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimestamp(String newTimestamp) {
/*		try {
			if (ts.getFormat() != null){
				ts.setValue(ts.getFormat().parseObject(newTimestamp));
			}
		} catch (ParseException e) {
			System.out.println(e);
		} */
		ts.setValue(newTimestamp);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Categories getCategories() {
		return categories;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCategories(Categories newCategories) {
		categories = newCategories;
	}

	// function for assignment
	public void assignCategories(Categories source) {
		categories = new SVGCategoriesImpl(_chart, _dgraphic);
		((SVGCategoriesImpl) categories).assign(source);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataSets getDataSets() {
		if (dataSets == null && _dgraphic != null) {
			dataSets = new SVGDataSetsImpl(_chart, _dgraphic);					
		}
		return dataSets;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDataSets(DataSets newDataSets) {
		dataSets = newDataSets;
	}

	// function for assignment
	public void assignDataSets(DataSets source) {
		dataSets = new SVGDataSetsImpl(_chart, _dgraphic);
		((SVGDataSetsImpl) dataSets).assign(source);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append("timestamp: ");
		result.append(timestamp);
		result.append(')');
		return result.toString();
	}

	// function for assignment
	public void constructModel() {
		if (_dgraphic.getChildOfClass(DTimeStamp.class) == null)
			_dgraphic.addChild(ts);
	}
} //DataImpl
