/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDataSetAssociationsImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDataSetAssociationsImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetAssociations;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;

import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data Set Associations</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetAssociationsImpl#getDataSetIds <em>Data Set Ids</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGDataSetAssociationsImpl extends SVGInputBase implements DataSetAssociations {
	/**
	 * The cached value of the '{@link #getDataSetIds() <em>Data Set Ids</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSetIds()
	 * @generated
	 * @ordered
	 */
	protected List dataSetIds = null;
	protected List curves = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGDataSetAssociationsImpl() {
		super();
	}

	public SVGDataSetAssociationsImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), new ArrayList());
	}

	public SVGDataSetAssociationsImpl(Chart chart, DGraphic dgraphic, List curves) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.curves = curves;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getDataSetIds() {
		if (dataSetIds == null) {
			if (_dgraphic != null) {
				
				// Search for the references to dataSets
				Data data = _chart.getData();
				DataSets dataSets = data.getDataSets();
				List dataSetList = dataSets.getDataSet();
				
				for (int i = 0; i < dataSetList.size(); ++i) {
					DataSet dataSet = (DataSet) dataSetList.get(i);
					dataSetIds = new ArrayList();
					// IDRefList dataSetidRefs = (IDRefList) dataSetIds;
					for (int j = 0; j < curves.size(); ++j) {
						DCurve curve = (DCurve)curves.get(j);
						if (dataSet.getId().compareTo(curve.getProperties().get(DCurve.P_ID).toString()) == 0) {
							//dataSetidRefs.add(dataSet, false);
							dataSetIds.add(dataSet);
						}
					}
				}
			} else {
				dataSetIds = new ArrayList();
			}
		}
		return dataSetIds;
	}

	public void assignDataSetIds(List source) {
		dataSetIds = new ArrayList();

		for (int i = 0; i < source.size(); i++){
			String sourceId = ((DataSet) source.get(i)).getId();
			dataSetIds.add(sourceId);
		}
	}
} //DataSetAssociationsImpl
