/* ***********************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDataSetColorImpl.java,v 1.3 2006/02/14 21:23:33 sleeloy Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetColor;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;

import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDColor;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data Set Color</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetColorImpl#getColor <em>Color</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetColorImpl#getDataSetId <em>Data Set Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGDataSetColorImpl extends SVGInputBase implements DataSetColor {
	/**
	 * The default value of the '{@link #getColor() <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColor()
	 * @generated
	 * @ordered
	 */
	protected static final IDColor COLOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getColor() <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColor()
	 * @generated
	 * @ordered
	 */
	protected IDColor color = COLOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDataSetId() <em>Data Set Id</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSetId()
	 * @generated
	 * @ordered
	 */
	protected Object dataSetId = null;
	protected DCurve curve = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SVGDataSetColorImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null);
	}
	
	public SVGDataSetColorImpl(Chart chart, DGraphic dgraphic, DCurve curve) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.curve = curve;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getColor() {
		if (color == COLOR_EDEFAULT) {
	
			color = (IDColor)curve.getProperties().get(DCurve.P_COLOR);
		}
		if (color != null)
			return color.serializeToString();
		else 
			return null;
	}
	
	public static boolean hasColor(DCurve curve){
		return (curve.getProperties().get(DCurve.P_COLOR) != null);
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColor(String newColor) {
		if (newColor != null && newColor != "" && !newColor.substring(0, 1).equals("#"))  // if the color name is not "#......"
			newColor = convertToHex(newColor);
		if (newColor == null || newColor == "") {	// if not matched, use default color
			curve.getProperties().remove(DCurve.P_COLOR);
			return;
		}
		else {

			curve.getProperties().store(DCurve.P_COLOR, ((SVGChartImpl)_chart).getColor(newColor));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getDataSetId() {
		if (dataSetId == null && _dgraphic != null) {
			// Search for the reference to DataSet
			String refId =  Integer.toString(EventTools.getHashCode(curve));
			Data data = _chart.getData();
			DataSets dataSets = data.getDataSets();
			List dataSetList = dataSets.getDataSet();
			for (int i = 0; i < dataSetList.size(); ++i) {
				DataSet dataSet = (DataSet) dataSetList.get(i);
				if ((dataSet.getId() != null) && (dataSet.getId().equals(refId))) {
					dataSetId = dataSet;
					break;
				}
			}
		}
		return dataSetId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDataSetId(Object newDataSetId) {
		dataSetId = newDataSetId;
		
		DataSet dataSet = null;
		String dataSetIdStr;
		try {
			dataSet = (DataSet) newDataSetId;
			dataSetIdStr = dataSet.getId();
			if (curve != null) {
				curve.setName(dataSetIdStr);
			}
		} catch (ClassCastException e) {
		}
	}

	
	// function for assignment
	public void assignDataSetId(Object newDataSetId) {
		try {
			DataSet dataSet = (DataSet) newDataSetId;
			String dataSetIdStr = dataSet.getId();
			if (curve != null) 
				curve.getProperties().store(DCurve.P_ID, dataSetIdStr);
		}catch (ClassCastException e) {
		}
	}
	
	// function for assignment
	public String fetchDataSetId() {
		return curve.getProperties().get(DCurve.P_ID).toString();
	}
	
	// function for assignment
	public void setDCurve(DCurve dcurve) {
		this.curve = dcurve;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (color: ");
		result.append(color);
		result.append(')');
		return result.toString();
	}
} //DataSetColorImpl
