/* ***********************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDataSetImpl.java,v 1.5 2006/02/14 21:23:32 sleeloy Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Palettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data Set</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetImpl#getDataPoint <em>Data Point</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetImpl#getCoordinates <em>Coordinates</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetImpl#getAccessibility <em>Accessibility</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetImpl#getEventHandler <em>Event Handler</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetImpl#getTooltip <em>Tooltip</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGDataSetImpl extends SVGInputBase implements DataSet {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getDataPoint() <em>Data Point</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataPoint()
	 * @generated
	 * @ordered
	 */
	protected List dataPoint = null;

	/**
	 * The cached value of the '{@link #getCoordinates() <em>Coordinates</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCoordinates()
	 * @generated
	 * @ordered
	 */
	protected List coordinates = null;

	/**
	 * The cached value of the '{@link #getAccessibility() <em>Accessibility</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessibility()
	 * @generated
	 * @ordered
	 */
	protected Accessibility accessibility = null;

	/**
	 * The cached value of the '{@link #getEventHandler() <em>Event Handler</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventHandler()
	 * @generated
	 * @ordered
	 */
	protected List eventHandler = null;
	
	protected Tooltip tooltip = null;
	
	protected DCurve curve = null;
	
	protected static final String DUMMY_CAT = "__dummy_cat__";

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGDataSetImpl() {
		super();
	}

	public SVGDataSetImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null);
	}

	public SVGDataSetImpl(Chart chart, DGraphic dgraphic, DCurve curve) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.curve = curve;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
	    return Integer.toString(EventTools.getHashCode(curve));//.getProperties().get(DCurve.P_ID, ID_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		curve.getProperties().store(DCurve.P_ID, newId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLabel() {
		if (curve.getName() == null)
			return LABEL_EDEFAULT;
		return curve.getName();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabel(String newLabel) {
		curve.setName(newLabel);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getDataPoint() {
		if (dataPoint == null) {
			buildCoordinateAndCatagoryData(curve );
		}
		return dataPoint;
	}
	
	// function for assignment
	public void assignDataPoint(List source) {
		assignCoordinatesAndDataPoints(source, false);	
	}
	
	protected void buildCoordinateAndCatagoryData(DCurve curve) {
		if (dataPoint == null) dataPoint = new ArrayList();
		if (coordinates == null) coordinates = new ArrayList();
		for (IDItem obj=curve.getFirstChild(); obj!=null; obj = obj.getNext()) {
			if (obj instanceof DPoint) {
				DPoint point = (DPoint) obj;
				boolean isCoordinate = true;
				IDCoord independantCoord = null;
				IDCoord dependantCoord = null;
//				IDCoord dependantCoord2 = null;
				IDCoord categoryCoord = null;
				for (IDItem item=point.getFirstChild(); item!=null; item = item.getNext()) {
					if (item instanceof IDCoord) {
						IDCoord coord = ((IDCoord) item);
						boolean isCategory = false;
						
						List list = (List) coord.getAxis().getChildrenOfClass(DCategory.class);
						if (list != null){
							if (list.size() > 0 ) {
								isCoordinate = false;
								isCategory = true;
							}
						}
						if (coord.getAxis() != null){
							if (coord.getAxis().getName().equals("x"))
								independantCoord = coord;
							else if (coord.getAxis().getName().equals("y"))
								dependantCoord = coord;
							else if (coord.getAxis().getName().equals("y2"))
								dependantCoord = coord;
							else if (isCategory)
								independantCoord = coord;
							else if (independantCoord == null)
								independantCoord = coord;
							else
								dependantCoord = coord;
							}
						

					}
				}
				//if this is a catagory coordinate then the indepnedat value is
				// the catagory value
				IDCoord x = null, y = null;
				if ((!isCoordinate) || (dependantCoord == null) ){
					if (dependantCoord == null) {
						dependantCoord = new DCoordObject();						
						dependantCoord.setValue(DUMMY_CAT);
						//check to see if we have categories
						List category = _chart.getData().getCategories().getCategory();
						if (category == null) category = new ArrayList();
						if (!(category.contains(DUMMY_CAT))){
							DCategory dcategory = new DCategory();
							dcategory.setLabel(DUMMY_CAT);
							dcategory.setId(DUMMY_CAT);
							category.add(new SVGCategoryImpl(_chart, _dgraphic, dcategory));
						}
						
						//need to switch coodinates
						IDCoord cordTemp = dependantCoord;
						dependantCoord = independantCoord;
						independantCoord = cordTemp;
						
					}
					dataPoint.add(new SVGCategoricalDataImpl(_chart, _dgraphic, point, (IDCoord) independantCoord, (IDCoord) dependantCoord));
				}
				else{
					coordinates.add(new SVGCoordinatesImpl(_chart, _dgraphic, point, (IDCoord) independantCoord, (IDCoord) dependantCoord));
				}
			}
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getCoordinates() {
		if (coordinates == null) {
			buildCoordinateAndCatagoryData(curve);
		}
		return coordinates;
	}

	// function for assignment
	public void assignCoordinates(List source) {
		assignCoordinatesAndDataPoints(source, true);
	}
	
	// function for assignment
	public void assignCoordinatesAndDataPoints(List source, boolean isCoord) {
		List axisList = null;
		List association = null;
		boolean useSecAxis = false;

		// create new Axes if independent and primary dependent axis is null
		if (((SVGAxesImpl) _chart.getConfiguration().getAxes()).getDIndepAxis() == null) 
			((SVGAxesImpl) _chart.getConfiguration().getAxes()).assignIndependentAxis(null);
		if (((SVGAxesImpl) _chart.getConfiguration().getAxes()).getDPriDepAxis() == null) 
			((SVGAxesImpl) _chart.getConfiguration().getAxes()).assignPrimaryDependentAxis(null);
		
		// get DAxis objects
		DAxis indepAxis = ((SVGAxesImpl) _chart.getConfiguration().getAxes()).getDIndepAxis();
		DAxis priDepAxis = ((SVGAxesImpl) _chart.getConfiguration().getAxes()).getDPriDepAxis();
		DAxis secDepAxis = ((SVGAxesImpl) _chart.getConfiguration().getAxes()).getDSecDepAxis();
		
		// see if the dataset uses secondary axis or not
		if (secDepAxis != null) {
			association = _chart.getConfiguration().getAxes().getSecondaryDependentAxis().getDataSetAssociations().getDataSetIds();
			if (association != null) {
				for (int k = 0; k < association.size(); k++) {
					String assoName = (String) association.get(k);
					if (assoName.equals(getId())) {
						useSecAxis = true;
						break;
					}
				}
			}
		}

		_dgraphic.addChild(curve);
		// create Coordinates objects
		if (isCoord) {
			coordinates = new ArrayList();
			for (int i = 0; i < source.size(); i++) {
				DPoint newPoint = new DPoint();
				curve.addChild(newPoint);

				double dummyValue = 0.0;	// the values will be set in SVGCoordinatesImpl
				DCoord independentCoord = new DCoord(indepAxis , dummyValue);
				DCoord dependentCoord = null;
				if (useSecAxis)
					dependentCoord = new DCoord(secDepAxis, dummyValue);
				else
					dependentCoord = new DCoord(priDepAxis, dummyValue);
				SVGCoordinatesImpl newCoord = new SVGCoordinatesImpl(_chart, _dgraphic, newPoint, (IDCoord) independentCoord, (IDCoord) dependentCoord);
				newCoord.assign(source.get(i));
				coordinates.add(newCoord);
				newPoint.addChild(independentCoord);
				newPoint.addChild(dependentCoord);
			}
		}
		else {
			dataPoint = new ArrayList();
			for (int i = 0; i < source.size(); i++) {
				DPoint newPoint = new DPoint();
				curve.addChild(newPoint);
				CategoricalData catData = (CategoricalData) source.get(i);
				double dummyValue = 0.0;	// the values will be set in SVGCoordinatesImpl
				Category catObj = (Category) catData.getCategoryId(); // it returns a Category object, not Id
				String catID = null;
				if (catObj != null) 		// put dummy category if no category is matched
					catID = catObj.getId();
				else 
					catID = "dummy";
				DCoordObject independentCoord = new DCoordObject(indepAxis , catID);
				DCoord dependentCoord = null;
				if (useSecAxis)
					dependentCoord = new DCoord(secDepAxis, dummyValue);
				else
					dependentCoord = new DCoord(priDepAxis, dummyValue);
				SVGCategoricalDataImpl newCoord = new SVGCategoricalDataImpl(_chart, _dgraphic, newPoint, (IDCoord) independentCoord, (IDCoord) dependentCoord);
				newCoord.assign(source.get(i));
				dataPoint.add(newCoord);
				newPoint.addChild(independentCoord);
				newPoint.addChild(dependentCoord);
			}
		}	
		
		// check if shape and dataSetColor is set for this curve.
		List shapeList = null;
		Shapes shapes = ((SVGConfigurationImpl) _chart.getConfiguration()).shapes;
		if (shapes != null)
			shapeList = ((SVGShapesImpl) shapes).shape;
		if (shapeList != null) {
			for (int i = 0; i < shapeList.size(); i++) {
				SVGShapeImpl shape = (SVGShapeImpl) shapeList.get(i);
				if (this.getId().equals(shape.fetchDataSetId())) {
					// copy attribute of the curve to this.curve and set curve to this.curve
					String shapeId = shape.getShapeId();
					if (shapeId != null) {
						shape.setDCurve(this.curve);
						shape.setShapeId(shapeId);
					}
					break;
				}
			}
		}
		List dataColorList = null;
		Palettes palettes = ((SVGConfigurationImpl) _chart.getConfiguration()).palettes;
		if (palettes != null)
			dataColorList = ((SVGPalettesImpl) palettes).dataSetColor;
		if (dataColorList != null) {
			for (int i = 0; i < dataColorList.size(); i++) {
				SVGDataSetColorImpl dataColor = (SVGDataSetColorImpl) dataColorList.get(i);
				if (this.getId().equals(dataColor.fetchDataSetId())) {
					// copy attribute of the curve to this.curve and set curve to this.curve
					String color = dataColor.getColor();
					if (color != null && color != "") {
						dataColor.setDCurve(this.curve);
						dataColor.setColor(color);
					}
					break;
				}
			}
		}
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Accessibility getAccessibility() {
		if (accessibility == null) {
			accessibility = getAccessibility(curve);				

		}
		return accessibility;		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccessibility(Accessibility newAccessibility) {
		accessibility = newAccessibility;
	}

	// function for assignment
	public void assignAccessibility(Accessibility source) {
		accessibility = new SVGAccessibilityImpl(_chart, _dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
		((SVGAccessibilityImpl) accessibility).assign(source);
		super.constructAccessibilityModel(accessibility, curve);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getEventHandler() {
		if (eventHandler == null) {
			eventHandler = getEventHandler(curve);
		}
		return eventHandler;
	}

	// function for assignment
	public void setEventHandler(List newEventHandler) {
		eventHandler = newEventHandler;
		super.constructEventHandlerModel(eventHandler, curve);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Tooltip getTooltip() {
		if (tooltip == null){
			if (curve.getTooltip() != null)
				tooltip = new SVGTooltipImpl(_chart, _dgraphic, curve.getTooltip());
		}
		return tooltip;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTooltip(Tooltip newTooltip) {
		tooltip = newTooltip;
		curve.setTooltip(newTooltip.getLabel());
	}

	// function for assignment
	public void assignTooltip(Tooltip source) {
		tooltip = new SVGTooltipImpl(_chart, _dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
		((SVGTooltipImpl) tooltip).assign(source);
		curve.setTooltip(tooltip.getLabel());
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(getId());
		result.append(", label: ");
		result.append(getLabel());
		result.append(')');
		return result.toString();
	}

	public DCurve getCurve() {
		return curve;
	}

} //DataSetImpl
