/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDataSetsImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDataSetsImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;

import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data Sets</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetsImpl#getDataSet <em>Data Set</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGDataSetsImpl extends SVGInputBase implements DataSets {
	/**
	 * The cached value of the '{@link #getDataSet() <em>Data Set</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSet()
	 * @generated
	 * @ordered
	 */
	protected List dataSet = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGDataSetsImpl() {
		super();
	}

	public SVGDataSetsImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGDataSetsImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getDataSet() {
		if (dataSet == null) {
			if (_dgraphic != null) {
				if (_dgraphic != null) {
					dataSet = new ArrayList();
					for (IDItem item=_dgraphic.getFirstChild(); item!=null;item=item.getNext()) {
						if (item instanceof DCurve)
							dataSet.add(new SVGDataSetImpl(_chart, _dgraphic, (DCurve)item));
					}
				} else {
					dataSet = new ArrayList();
				}
			}				
		}
		return dataSet;
	}

	// function for assignment
	public void setDataSet(List newDataSet) {
		dataSet = newDataSet;
	}
	
} //DataSetsImpl
