/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDataValueImpl.java,v 1.3 2005/12/16 09:47:07 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/*
 * Created on Jan 24, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.IConstants;

import org.eclipse.tptp.platform.report.core.internal.DGraphic;

/**
 * @author sleeloy
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SVGDataValueImpl extends SVGInputBase implements DataValue {

	protected String percentageVisibility;
	protected String valueVisibility;
	
	protected NumberFormat numberFormat;

	public SVGDataValueImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGDataValueImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue#getPercentageVisibility()
	 */
	public String getPercentageVisibility() {
		Boolean visible = (Boolean)_dgraphic.getProperties().get(DGraphic.P_SHOW_PERCENTAGE, Boolean.FALSE);
		//percentageVisibility =  IConstants.HIDDEN;		
		if (visible != null) {
			if (visible.booleanValue())
				percentageVisibility =  IConstants.VISIBLE;
			else
				percentageVisibility = IConstants.HIDDEN;
		}
		return percentageVisibility;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue#setPercentageVisibility(java.lang.String)
	 */
	public void setPercentageVisibility(String value) {
		percentageVisibility = value;
		_dgraphic.getProperties().store(DGraphic.P_SHOW_PERCENTAGE, percentageVisibility.equals(IConstants.VISIBLE));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue#getValueVisibility()
	 */
	public String getValueVisibility() {
		Boolean visible = (Boolean)_dgraphic.getProperties().get(DGraphic.P_SHOW_VALUES, Boolean.FALSE);
		//valueVisibility =  IConstants.HIDDEN;		
		if (visible != null) {
			if (visible.booleanValue())
				valueVisibility =  IConstants.VISIBLE;
			else
				valueVisibility = IConstants.HIDDEN;
		}
		return valueVisibility;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue#setValueVisibility(java.lang.String)
	 */
	public void setValueVisibility(String value) {
		valueVisibility = value;
		_dgraphic.getProperties().store(DGraphic.P_SHOW_VALUES, valueVisibility.equals(IConstants.VISIBLE));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue#getNumberFormat()
	 */
	public NumberFormat getNumberFormat() {
		if (numberFormat == null && _dgraphic != null) {			
			String format =  (String)_dgraphic.getProperties().get(DGraphic.P_VALUE_FORMAT);
			if (format != null)
				numberFormat = new SVGNumberFormatImpl(_chart, _dgraphic, format);					
		}
		return numberFormat;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue#setNumberFormat(org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat)
	 */
	public void setNumberFormat(NumberFormat value) {
		numberFormat = value;

	}

	// function for assignment
	public void assignNumberFormat(NumberFormat source) {
		numberFormat = new SVGNumberFormatImpl(_chart, _dgraphic, SVGNumberFormatImpl.PATTERN_EDEFAULT);
		((SVGNumberFormatImpl) numberFormat).assign(source);
		_dgraphic.getProperties().store(DGraphic.P_VALUE_FORMAT, source.getPattern());
	}
}
