/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDependentAxisDefinitionImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDependentAxisDefinitionImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetAssociations;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DependentAxisDefinition;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Dependent Axis Definition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDependentAxisDefinitionImpl#getDataSetAssociations <em>Data Set Associations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGDependentAxisDefinitionImpl extends SVGAxisDefinitionImpl implements DependentAxisDefinition {
	/**
	 * The cached value of the '{@link #getDataSetAssociations() <em>Data Set Associations</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSetAssociations()
	 * @generated
	 * @ordered
	 */
	protected DataSetAssociations dataSetAssociations = null;
	protected String dependantId;
	
	public static final String DEFAULT_DEPENDANT_ID="y";

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGDependentAxisDefinitionImpl() {
		super();
	}

	public SVGDependentAxisDefinitionImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null, DEFAULT_DEPENDANT_ID);
	}

	public SVGDependentAxisDefinitionImpl(Chart chart, DGraphic dgraphic, DAxis axis, String dependantId) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.axis = axis;
		this.dependantId = dependantId;
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataSetAssociations getDataSetAssociations() {
		if (dataSetAssociations == null && _dgraphic != null) {
				List curves = new ArrayList();
				for (IDItem item = _dgraphic.getFirstChild(); item!=null; item=item.getNext()) {
					if (item instanceof DCurve){
						List axis = new ArrayList();
						for (IDItem point = ((DCurve)item).getFirstChild(); point!=null; point=point.getNext()) {
							if (point instanceof DPoint){
							    for (IDItem coord = ((DPoint) point).getFirstChild(); coord!=null; coord=coord.getNext()) {
									if (coord instanceof DCoord)
										axis.add(((DCoord)coord).getAxis());
								}		
								if (axis.size() != 0) break;
							}
							if (axis.size() != 0) break;
						}
						if (axis.size() != 0) {
							// check if any of the axes has the name "y2"
							for (int j = 0; j < axis.size(); j++)
								if (((DAxis) axis.get(j)).getName().equals(dependantId)) 
									curves.add(item);		// assume the same curve do not have two "y2" coordinates
						}
//						else if (DEFAULT_DEPENDANT_ID.equals(dependantId))
//							curves.add(item);
					}
				}
				dataSetAssociations = new SVGDataSetAssociationsImpl(_chart, _dgraphic, curves);					
		}
		
		return dataSetAssociations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDataSetAssociations(DataSetAssociations newDataSetAssociations) {
		dataSetAssociations = newDataSetAssociations;
	}
	
	// function for assignment
	public void assignDataSetAssociations(DataSetAssociations source) {
		dataSetAssociations = new SVGDataSetAssociationsImpl(_chart, _dgraphic, null);
		((SVGDataSetAssociationsImpl) dataSetAssociations).assign(source);
	}

} //DependentAxisDefinitionImpl
