/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGInputBase.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGInputBase.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;
import org.w3c.dom.Element;

import org.eclipse.tptp.platform.report.core.internal.DAccessibilityDesc;
import org.eclipse.tptp.platform.report.core.internal.DAccessibilityTitle;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DColorRegistry;
import org.eclipse.tptp.platform.report.core.internal.DEvent;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DItemContainer;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

/**
 * @author hkyleung
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public abstract class SVGInputBase {
	protected static DColorRegistry colors;
	protected Chart _chart;
	/**
	 * @return Returns the _dgraphic.
	 */
	public DGraphic getDGraphic() {
		return _dgraphic;
	}
	/**
	 * @param _dgraphic The _dgraphic to set.
	 */
	public void setDGraphic(DGraphic _dgraphic) {
		this._dgraphic = _dgraphic;
	}
	protected DGraphic _dgraphic;
	
	protected static Hashtable colorTable = new Hashtable();
	/**
	 * @return
	 */
	public Element getElement() {
		return null;
	}

	/**
	 * @param element
	 */
	public void setElement(Element element) {
	}
	
	// virtual method for model construction
	public void constructModel() {}
	
	// for debugging purpose only: uncomment the line to print out debugging text
	public void log(String text) {
//		System.out.print(text);
	}
	
	// for debugging purpose only: uncomment the line to print out debugging text
	public void logln(String text) {
//		System.out.println(text);
	}
	/**
	 * Helper method that creates an Accessibilty object based on a DItemContainer object
	 * @param container
	 * @return
	 */
	protected Accessibility getAccessibility(IDItem container) {
		if (_dgraphic != null) {
			String title = null;
			String desc = null;
			for (IDItem item = container.getFirstChild(); item!=null;item=item.getNext()) {
				if (item.getParent() == container) {
					if (item instanceof DAccessibilityTitle) {
						title = ((DAccessibilityTitle) item).getText();
					} else if (item instanceof DAccessibilityDesc)  {
						desc = ((DAccessibilityDesc) item).getText();
					}
				}
				if ((title != null) && (desc != null))
					return new SVGAccessibilityImpl(_chart, _dgraphic, title, desc);
			}
		}
		return null;
	}
	
	/**
	 * Helper method that creates a list of EventHandler object based on a DItemContainer object
	 * @param container
	 * @return
	 */
	protected List getEventHandler(DItemContainer container) {
		List eventHandler = new ArrayList();
		if (_dgraphic != null) {
			eventHandler = new ArrayList();
			for (IDItem item = container.getFirstChild(); item!=null;item=item.getNext()) {
				if ((item instanceof DEvent) && (item.getParent() == container)) 
					eventHandler.add(new SVGEventHandlerImpl(_chart, _dgraphic, (DEvent)item));
			}
		}
		return eventHandler;
	}	
	
	/**
	 * Helper method that creates a list of EventHandler object based on a property on a DGraphic object
	 * @param container
	 * @return
	 */
	protected List getEventHandler(DPropertyStore propertyStore, String property) {
	List eventHandler = new ArrayList();
	if (_dgraphic != null) {
		eventHandler = new ArrayList();
		List list = (List)propertyStore.get(property);
		if (list != null){
			for (int x = 0; x < list.size(); x++){
				Object item = list.get(x); 
				if (item instanceof DEvent)
					eventHandler.add(new SVGEventHandlerImpl(_chart, _dgraphic, (DEvent)item));
			}
		}
	}
	return eventHandler;	
	}	

	// construct model for Accessibility
	protected void constructAccessibilityModel(Accessibility acc, IDItem parent) {
		IDItem accTitle = ((SVGAccessibilityImpl) acc).getDAccessibilityTitle();
		IDItem accDesc = ((SVGAccessibilityImpl) acc).getDAccessibilityDesc();
		parent.addChild(accTitle);
		parent.addChild(accDesc);
	}
	
	// construct model for EventHandler
	protected void constructEventHandlerModel(List eventhandler, IDItem parent) {
		for (int i = 0; i < eventhandler.size(); i++) {
			IDItem event = ((SVGEventHandlerImpl) eventhandler.get(i)).getDEvent();
			parent.addChild(event);
		}
	}
	
	// search the index of the function in the list with the name supplied
	// it returns the index if the search is successful, else, return -1 for failure
	private int search(Method[] list, String name) {
		for (int i = 0; i < list.length; i++) {
			if (list[i].toString().indexOf(name) != -1)
				return i;
		}
		// return -1 when the string is not found
		return -1;
	} 
	
	// call get method with method as a parameter
	private Object getObject(Method method, Object source) {
		Object[] arg = new Object[0];
		Object get_result = null;
		try {
			get_result = method.invoke(source, arg);
			log(method.getName() + " = " + get_result + " ");
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		return get_result;
	}
	
	// call get method with method name as a String
	private Object getObject(Method[] list, String name, Object source) {
			int index = search(list, name);
			Object[] arg = new Object[0];
			Object get_result = null;
			try {
				if (index >= 0) {
					get_result = list[index].invoke(source, arg);
					log(list[index].getName() + " = " + get_result + " ");
				}
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
			return get_result;
	}
	
	// call set or assign method with method name as a String
	private void setObject(Method[] list, String name, Object source, Object[] arg) {
		int index = search(list, name);
		try {
			if (index >= 0) {
				list[index].invoke(source, arg);
				logln(" >> " + list[index].getName());
			}
			else
				logln(" >> Set method not found");
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
	}
	
	/* the assign function invokes function for the "get" method and "is" method
	 *  Case A, "get" method:
	 *     1.  the method return type is a primitive or a String
	 *           check if there is an associate isSet method
	 *           if there is an associate isSet method, invoke isSetPrimitive()
	 *           if source.isSetPrimitive() is true, or isSet method is not found, 
	 *           check if source.getPrimitive() is null, if not, call
	 *           setPrimitive(source.getPrimitive()) 
	 *     2.  if the method return type is a List
	 *     		If method is get....Id(), do not do anything
	 *     		check if source.getList() is null, if not, 
	 *           call the listFactory() method to create the list
	 *           if the list cannot be created, call assignList(Object) method 
	 *             defined in subclass
	 *           else, pass the reference to the List to subclass using 
	 *             setList(List) method  
	 *     3.  if the method return type is a SVG Class Object or a java.lang.Object
	 *     		check if source.getObject() is null, if not, 
	 *           call assignObject(Object) in the subclass
	 *     4.  for all other return type, do nothing
	 *  Case B, "is" method:
	 *     search and call its isSet method.  If source.isSetPrimitive() is true,
	 *     and source.getPrimitive() is not null, call setPrimitive(source.getPrimitive()).  
	 */
	public void assign(Object source) {
		Class c = source.getClass();
		logln("\n current class: " + c.getName());
		// get the method list of the class that invokes this function
		Method[] sourceMethod = source.getClass().getMethods();
		Method[] selfMethod = this.getClass().getMethods();

		// store the substring of the method to be called
		String methodSubstring = null;
		
		// Loop through the method list to identify all the "get" and "is" methods
		for (int i = 0; i < sourceMethod.length; i++) {
			// find out all the methods that are prefixed with "get"
			if (sourceMethod[i].getName().substring(0, 3).equals("get")) {
				log(sourceMethod[i].getName().substring(3) + " - ");
				Class returnType = sourceMethod[i].getReturnType();
				if (returnType.isPrimitive() || returnType.getName().equals("java.lang.String")) {
					log("primitive: ");
					Object get_result = getObject(sourceMethod[i], source);
					if (get_result != null) {
						// find isSet method.  If isSet method is present and 
						// source.isSetxx() is true, call set function
						methodSubstring = ".isSet" + sourceMethod[i].getName().substring(3) + "(";
						Object isSet_result = getObject(sourceMethod, methodSubstring, source);
						// isSet method not found if equals null, so set attribute anyway
						if (isSet_result == null || isSet_result.toString().equals("true")) {
							methodSubstring = ".set" + sourceMethod[i].getName().substring(3) + "(";
							setObject(selfMethod, methodSubstring, this, new Object[] {get_result});
						}
						else
							logln("   do not set");
					}
					else
						logln("");
				}
				else if (returnType.getName().equals("java.util.List")) {
					log("List: ");
					List result = null;
					// see if the source list is empty or not
					List resultList = (List) getObject(sourceMethod[i], source);
					
					if (resultList != null && resultList.size() != 0) {
						// do not copy for get...Ids case 
						if (sourceMethod[i].getName().substring(3).indexOf("Id") != -1) 
							result = null;
						else
							result = listFactory(resultList);
						
						// if the list cannot be constructed from listFactory
						// call the assign function instead
						if (result == null) {
							methodSubstring = ".assign"+sourceMethod[i].getName().substring(3) + "(";
							setObject(selfMethod, methodSubstring, this, new Object[] {resultList});
						}
						// pass the reference of the new list to the class
						else {
							methodSubstring = ".set"+sourceMethod[i].getName().substring(3) + "(";
							setObject(selfMethod, methodSubstring, this, new Object[] {result});
						}
					}
					else
						logln("");
					
				}
				else if (returnType.getName().toString().indexOf("org.eclipse.tptp.platform.report.chart.svg.internal.input") != -1
						|| (returnType.getName().toString().indexOf("java.lang.Object") != -1)) {
					log("Object: ");
					InputBase get_result = (InputBase) getObject(sourceMethod[i], source);
					if (get_result != null) {
						methodSubstring = ".assign"+sourceMethod[i].getName().substring(3) + "(";
						setObject(selfMethod, methodSubstring, this, new Object[]{get_result});
					}
					else
						logln("");
				}
				else
					logln(returnType.getName());
			}
			// contain "is" but not "isSet"
			else if (sourceMethod[i].getName().substring(0, 2).equals("is") &&
					! (sourceMethod[i].getName().substring(2, 5).equals("Set"))) {
				log(sourceMethod[i].getName().substring(2) + " - ");
				// get result from source.isSetBool()
				methodSubstring = ".isSet" + sourceMethod[i].getName().substring(2) + "(";
				Object isSet_result = getObject(sourceMethod, methodSubstring, source);
				if (isSet_result.toString().equals("true")) {
					// use setBool(source.isBool())
					Object is_result = getObject(sourceMethod[i], source);
					if (is_result != null) {
						methodSubstring = ".set"+sourceMethod[i].getName().substring(2) + "(";
						setObject(selfMethod, methodSubstring, this, new Object[] {is_result});
					}
					else
						logln("");
				}
				else
					logln("");
			}
		}
		this.constructModel();
		logln("return");
	}
	
	/* first construct a class of the SVG element inside the sourceList
	 * then get the constructors for this class, select the constructor that 
	 * takes in Chart, DGraphic and DObject.  
	 * if the constructor in this form cannot be found, return null
	 * instantiate a new instance for DObject (no parameter)
	 * instantiate a new instance of SVG class object
	 * call assignObject(source list element) on individual element
	 * add each element to the list and return the list
	 */
	protected List listFactory(List sourceList) {
		List newList = new ArrayList();
		try{
			// construct a class name of org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVG...Impl
			String class_string = sourceList.get(0).getClass().toString();
			int last_dot = class_string.lastIndexOf(".") + 1;
			String jscrib_string = "org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVG" + class_string.substring(last_dot);
			Class c = Class.forName(jscrib_string);
		
			// get the constructors for the class
			Class[] parameter = null;
			Constructor[] theConstructors = c.getConstructors();
			int con = 0;
			// the constructor should have the form of {Chart, DGraphic, DObject}
			for (int j = 0; j < theConstructors.length; j++)
				if (theConstructors[j].getParameterTypes().length == 3) {
					parameter = theConstructors[j].getParameterTypes();
					con = j;
					break;
				}
			
			// if incorrect number of parameters are found in the constructor, 
			// let the individual class to handle the create of the list themselves
			if (parameter == null || parameter.length != 3) {
				return null;
			}
			
			// get the last parameter in the constructor
			Constructor[] itemConstructor = parameter[2].getConstructors();
			// find default constructor (no parameter) for the last parameter
			int defaultCon = 0;
			for (int k = 0; k < itemConstructor.length; k++) 
				if (itemConstructor[k].getParameterTypes().length == 0) {
					defaultCon = k;
					break;
				}	
			
			for (int i = 0; i < sourceList.size(); i++) {
				// create a new instance of the object for the constructor
				Object[] item_arg = new Object[] {};
				Object item = itemConstructor[defaultCon].newInstance(item_arg);
				
				// construct an argument list
				Object[] argument = new Object[] {_chart, _dgraphic, item};

				// create a new cell in the List
				SVGInputBase cell = (SVGInputBase) theConstructors[con].newInstance(argument);
				cell.assign(sourceList.get(i));
				newList.add(cell);
			}
		} catch (ClassNotFoundException e) {
			System.out.println(e);
		} catch (InstantiationException e) {
			System.out.println(e);
		} catch (IllegalAccessException e) {
			System.out.println(e);
		} catch (IllegalArgumentException e) {
			System.out.println(e);
		} catch (InvocationTargetException e) {
			System.out.println(e);
		}
		return newList;
	}
	
	// initHashTable function creates a hard table of colour in string mapping 
	// to a Hexidecimal representation
	protected String convertToHex(String colorId) {
		if (colorId.equals("white")) return "#FFFFFF";
		if (colorId.equals("blue")) return "#0000FF";
		if (colorId.equals("red")) return "#FF0000";
		if (colorId.equals("green")) return "#008B00";
		if (colorId.equals("yellow")) return "#FFFF00";
		if (colorId.equals("magenta")) return "#FF00FF";
		if (colorId.equals("cyan")) return "#00FFFF";
		if (colorId.equals("darkgrey")) return "#555555";
		if (colorId.equals("darkblue")) return "#000080";
		if (colorId.equals("darkred")) return "#800000";
		if (colorId.equals("darkgreen")) return "#008000";
		if (colorId.equals("darkyellow")) return "#808000";
		if (colorId.equals("darkmagenta")) return "#800080";
		if (colorId.equals("darkcyan")) return "#008080";
		if (colorId.equals("gold")) return "#FFD700";
		if (colorId.equals("lightgrey")) return "#AAAAAA";
		if (colorId.equals("lightblue")) return "#8080FF";
		if (colorId.equals("lightred")) return "#FF8080";
		if (colorId.equals("lightgreen")) return "#80FF80";
		if (colorId.equals("lightyellow")) return "#FFFF80";
		if (colorId.equals("lightmagenta")) return "#FF80FF";
		if (colorId.equals("lightcyan")) return "#80FFFF";
		if (colorId.equals("lilac")) return "#EE82EE";
		if (colorId.equals("turquoise")) return "#40E0D0";
		if (colorId.equals("aquamarine")) return "#7FFFD4";
		if (colorId.equals("khaki")) return "#F0E68C";
		if (colorId.equals("purple")) return "#A020F0";
		if (colorId.equals("yellowgreen")) return "#9ACD32";
		if (colorId.equals("pink")) return "#FFC0CB";
		if (colorId.equals("orange")) return "#FFA500";
		if (colorId.equals("orchid")) return "#DA70D6";
		if (colorId.equals("black")) return "#000000";
		return null;
	}
	
	/** @return the IDColor with is stored in the node. The node value can be
	 * a color id or a color defined with the format #RRGGBBAA
	 */
    protected String getColor(DColor color)
	{   
    	if (color == null) return null;
    	Color c = new Color(color.getRed(),color.getGreen(),color.getBlue());
        return "#"+Integer.toHexString( c.getRGB() & 0x00ffffff );
    }	
    

        
} 
