/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGInputFactoryImpl.java,v 1.2 2005/12/16 09:47:08 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGInputFactoryImpl.java,v 1.2 2005/12/16 09:47:08 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.ChartArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Coordinates;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetAssociations;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetColor;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DateFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DependentAxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Ecmascript;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.EventHandler;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Legend;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerRegion;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Palettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.PlotArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Preferences;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Scripts;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shape;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Size;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Timestamp;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.TitleBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition;

/**
 * @author hhleung
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class SVGInputFactoryImpl implements InputFactory {
	
//	public InputFactoryImpl() {
//	}
	
//	public InputFactoryImpl(Element rootElem) {
//		_root = rootElem;
//		_chart = new ChartImpl(_root);
//	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createAccessibility(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Accessibility createAccessibility(Chart chart) {
		return new SVGAccessibilityImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createUnitDefinition(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public UnitDefinition createUnitDefinition(Chart chart) {
		return new SVGUnitDefinitionImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createMarkerLine(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public MarkerLine createMarkerLine(Chart chart) {
		return new SVGMarkerLineImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createMarkerRegion()
	 */
	public MarkerRegion createMarkerRegion(Chart chart) {
		return new SVGMarkerRegionImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createNumberFormat(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public NumberFormat createNumberFormat(Chart chart) {
		return new SVGNumberFormatImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createDateFormat(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public DateFormat createDateFormat(Chart chart) {
		return new SVGDateFormatImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createEventHandler(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public EventHandler createEventHandler(Chart chart) {
		return new SVGEventHandlerImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createTooltip(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Tooltip createTooltip(Chart chart) {
		return new SVGTooltipImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createAxisDefinition(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public AxisDefinition createAxisDefinition(Chart chart) {
		return new SVGAxisDefinitionImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createDataSetAssociations(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public DataSetAssociations createDataSetAssociations(Chart chart) {
		return new SVGDataSetAssociationsImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createDependentAxisDefinition(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public DependentAxisDefinition createDependentAxisDefinition(Chart chart) {
		return new SVGDependentAxisDefinitionImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createAxes(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Axes createAxes(Chart chart) {
		return new SVGAxesImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createCategory(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Category createCategory(Chart chart) {
		return new SVGCategoryImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createCategories(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Categories createCategories(Chart chart) {
		return new SVGCategoriesImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createCategoricalData(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public CategoricalData createCategoricalData(Chart chart) {
		return new SVGCategoricalDataImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createCoordinates(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Coordinates createCoordinates(Chart chart) {
		return new SVGCoordinatesImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public DataSet createDataSet(Chart chart) {
		return new SVGDataSetImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createDataSets(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public DataSets createDataSets(Chart chart) {
		return new SVGDataSetsImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createData(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Data createData(Chart chart) {
		return new SVGDataImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createInternationalization(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Internationalization createInternationalization(Chart chart) {
		return new SVGInternationalizationImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createSize(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Size createSize(Chart chart) {
		return new SVGSizeImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createTitleBar(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public TitleBar createTitleBar(Chart chart) {
		return new SVGTitleBarImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createDataValue(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public DataValue createDataValue(Chart chart) {
		return new SVGDataValueImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createLegend(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Legend createLegend(Chart chart) {
		return new SVGLegendImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createTimestamp(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Timestamp createTimestamp(Chart chart) {
		return new SVGTimestampImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createChartArea(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public ChartArea createChartArea(Chart chart) {
		return new SVGChartAreaImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createPlotArea(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public PlotArea createPlotArea(Chart chart) {
		return new SVGPlotAreaImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createShape(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Shape createShape(Chart chart) {
		return new SVGShapeImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createShapes(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Shapes createShapes(Chart chart) {
		return new SVGShapesImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createDataSetColor(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public DataSetColor createDataSetColor(Chart chart) {
		return new SVGDataSetColorImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createPalettes(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Palettes createPalettes(Chart chart) {
		return new SVGPalettesImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createPreferences(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Preferences createPreferences(Chart chart) {
		return new SVGPreferencesImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createEcmascript(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Ecmascript createEcmascript(Chart chart) {
		return new SVGEcmascriptImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createScripts(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Scripts createScripts(Chart chart) {
		return new SVGScriptsImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createConfiguration(org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart)
	 */
	public Configuration createConfiguration(Chart chart) {
		return new SVGConfigurationImpl((SVGChartImpl)chart);
	}

	/* (non-Javadoc)
	 * @see  org.eclipse.tptp.platform.report.chart.svg.internal.input.InputFactory#createChart()
	 */
	public Chart createChart() {
		return new SVGChartImpl();
	}

}
