/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGInternationalizationImpl.java,v 1.2 2005/12/16 09:47:08 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGInternationalizationImpl.java,v 1.2 2005/12/16 09:47:08 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization;

import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Internationalization</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInternationalizationImpl#getCountry <em>Country</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInternationalizationImpl#getLanguage <em>Language</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInternationalizationImpl#getTextDirection <em>Text Direction</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGInternationalizationImpl extends SVGInputBase implements Internationalization {

	/**
	 * The default value of the '{@link #getCountry() <em>Country</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountry()
	 * @generated
	 * @ordered
	 */
	protected static final String COUNTRY_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getLanguage() <em>Language</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLanguage()
	 * @generated
	 * @ordered
	 */
	protected static final String LANGUAGE_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getTextDirection() <em>Text Direction</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTextDirection()
	 * @generated
	 * @ordered
	 */
	protected static final String TEXT_DIRECTION_EDEFAULT = "LTR";

	/**
	 * This is true if the Text Direction attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean textDirectionESet = false;

	/**
	 * The default value of the '{@link #getResourceBundle() <em>Resource Bundle</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResourceBundle()
	 * @generated
	 * @ordered
	 */
	protected static final String RESOURCE_BUNDLE_EDEFAULT = null;

	protected DI18N i18n;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGInternationalizationImpl() {
		super();
	}

	public SVGInternationalizationImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

//	protected String getDGraphicString(String chartStr){
//		return  (chartStr.equals(DI18N.DEF_RTL))? DI18N.DEF_RTL: ""; 
//	}
//
//	protected String getSVGChartString(String dgraphicStr){
//		return  (dgraphicStr.equals(DI18N.DEF_RTL))? "RTL": "LTR"; 
//	}
	public SVGInternationalizationImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
		i18n = (DI18N)_dgraphic.getChildOfClass(DI18N.class);
		if (i18n == null){ 
			i18n = new DI18N();
			i18n.setTextDirection(TEXT_DIRECTION_EDEFAULT);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getCountry() {
		return i18n.getCountry();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCountry(String newCountry) {
		i18n.setCountry(newCountry);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLanguage() {
		return i18n.getLanguage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLanguage(String newLanguage) {
		i18n.setLanguage(newLanguage);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTextDirection() {
		// Handle default value
		if (i18n.getTextDirection() != DI18N.DEF_LTR)
			textDirectionESet = true;
		return i18n.getTextDirection();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTextDirection(String newTextDirection) {
		textDirectionESet = true;
		i18n.setTextDirection(newTextDirection);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetTextDirection() {
		textDirectionESet = false;
		i18n.setTextDirection(TEXT_DIRECTION_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetTextDirection() {
		if (textDirectionESet == false) {
			getTextDirection();
		}
		return textDirectionESet;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization#getResourceBundle()
	 */
	public String getResourceBundle() {
		return	i18n.getResourceBundle();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization#setResourceBundle(java.lang.String)
	 */
	public void setResourceBundle(String newResourceBundle) {
		i18n.setResourceBundle(newResourceBundle);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization#getTimezone()
	 */
	public String getTimezone() {
		return i18n.getTimeZone();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization#setTimezone(java.lang.String)
	 */
	public void setTimezone(String value) {
		i18n.setTimeZone(value);
	}	

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (country: ");
		result.append(getCountry());
		result.append(", language: ");
		result.append(getLanguage());
		result.append(", timezone: ");
		result.append(getTimezone());
		result.append(", textDirection: ");
		if (textDirectionESet) result.append(getTextDirection()); else result.append("<unset>");
		result.append(", resourceBundle: ");
		result.append(getResourceBundle());
		result.append(')');
		return result.toString();
	}

	// function for assignment
	public void constructModel() {
		if (_dgraphic.getChildOfClass(DI18N.class) == null)
			_dgraphic.addChild(i18n);
	}
} //InternationalizationImpl
