/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGLegendImpl.java,v 1.5 2005/06/10 01:43:57 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGLegendImpl.java,v 1.5 2005/06/10 01:43:57 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Legend;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.tools.internal.DAlignmentPair;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Legend</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGLegendImpl#getBackgroundColor <em>Background Color</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGLegendImpl#getHeight <em>Height</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGLegendImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGLegendImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGLegendImpl#isShow <em>Show</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGLegendImpl#getTitle <em>Title</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGLegendImpl#getWidth <em>Width</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGLegendImpl extends SVGInputBase implements Legend {
	/**
	 * The default value of the '{@link #getBackgroundColor() <em>Background Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBackgroundColor()
	 * @generated
	 * @ordered
	 */
	protected static final String BACKGROUND_COLOR_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getMargin() <em>Margin</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMargin()
	 * @generated
	 * @ordered
	 */
	protected static final int MARGIN_EDEFAULT = 10;
	
	/**
	 * The default value of the '{@link #getHeight() <em>Height</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeight()
	 * @generated
	 * @ordered
	 */
	protected static final double HEIGHT_EDEFAULT = 0.0;


	/**
	 * This is true if the Height attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean heightESet = false;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCATION_EDEFAULT = "RIGHT";


	/**
	 * This is true if the Location attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean locationESet = false;

	/**
	 * The default value of the '{@link #isShow() <em>Show</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShow()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_EDEFAULT = true;


	/**
	 * This is true if the Show attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean showESet = false;

	/**
	 * The default value of the '{@link #getTitle() <em>Title</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTitle()
	 * @generated
	 * @ordered
	 */
	protected static final String TITLE_EDEFAULT = null;


	/**
	 * The default value of the '{@link #getWidth() <em>Width</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWidth()
	 * @generated
	 * @ordered
	 */
	protected static final double WIDTH_EDEFAULT = 0.0;


	/**
	 * This is true if the Width attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean widthESet = false;
	
	/**
	 * This is true if the Margin attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */	
	protected boolean marginESet = false;
	
	protected IDAlignment alignment = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGLegendImpl() {
		super();
	}

	public SVGLegendImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGLegendImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
		alignment = (DAlignmentPair)_dgraphic.getProperties().get(DGraphic.P_LEGEND_LAYOUT);
/*		if (alignment == null){
			alignment = new DAlignmentPair();
			alignment.setAlignment(IDAlignment.RIGHT);
			_dgraphic.getProperties().store(DGraphic.P_LEGEND_LAYOUT, alignment);
		} 
		*/
	}

	public String getBackgroundColor() {
		DColor color = ((DColor)_dgraphic.getProperties().get(DGraphic.P_LEGEND_BACKCOLOR));
		if (color != null)
			return color.serializeToString();
		return BACKGROUND_COLOR_EDEFAULT;
	}

	public void setBackgroundColor(String newBackgroundColor) {
		if (newBackgroundColor != null && newBackgroundColor != "" && !newBackgroundColor.substring(0, 1).equals("#"))  // if the color name is not "#......"
			newBackgroundColor = convertToHex(newBackgroundColor);
		if (newBackgroundColor == null || newBackgroundColor == "") {	// if not matched, use default color
			_dgraphic.getProperties().remove(DGraphic.P_BACKCOLOR);
			return;
		}
		_dgraphic.getProperties().store(DGraphic.P_LEGEND_BACKCOLOR, ((SVGChartImpl)_chart).getColor(newBackgroundColor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
        return _dgraphic.getProperties().get(DGraphic.P_LEGEND_ID, ID_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		_dgraphic.getProperties().store(DGraphic.P_LEGEND_ID, newId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLocation() {
		locationESet = true;
		String location = (String) _dgraphic.getProperties().get(DGraphic.P_LEGEND_LOCATION);
		if (location != null) 
			return location;
		if (alignment != null) {
			if (alignment.haveOneOfAlignment(IDAlignment.LEFT))
				return "W";
			else if (alignment.haveOneOfAlignment(IDAlignment.RIGHT))
				return "E";
			else if (alignment.haveOneOfAlignment(IDAlignment.TOP))
				return "N";
			else if (alignment.haveOneOfAlignment(IDAlignment.BOTTOM))
				return "S";
			else {
				locationESet = false;
				return "E";
			}
		}
		else {
			locationESet = false;
			return "TRAILING";  // this is the default
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocation(String newLocation) {
		locationESet = true;
		if (newLocation.equalsIgnoreCase("E") || newLocation.equalsIgnoreCase("W") ||
			newLocation.equalsIgnoreCase("N") || newLocation.equalsIgnoreCase("S")) {
			if (alignment == null){
				alignment = new DAlignmentPair();
				_dgraphic.getProperties().store(DGraphic.P_LEGEND_LAYOUT, alignment);
			} 
			if (newLocation.trim().equalsIgnoreCase("E"))
				alignment.setAlignment(IDAlignment.RIGHT);
			else if (newLocation.trim().equalsIgnoreCase("W"))
				alignment.setAlignment(IDAlignment.LEFT);
			else if (newLocation.trim().equalsIgnoreCase("N"))
				alignment.setAlignment(IDAlignment.TOP);
			else // "S"
				alignment.setAlignment(IDAlignment.BOTTOM);
		}
		else
			_dgraphic.getProperties().store(DGraphic.P_LEGEND_LOCATION, newLocation);
			// alignment.setAlignment(IDAlignment.RIGHT);				
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetLocation() {
		locationESet = false;
		alignment.setAlignment(IDAlignment.RIGHT);				
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetLocation() {
		if (locationESet == false) {
			getLocation();
		}
		return locationESet;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isShow() {
		if (_dgraphic.getProperties().get(DGraphic.P_SHOW_LEGEND) != null)
			showESet = true;
		return _dgraphic.getProperties().get(DGraphic.P_SHOW_LEGEND, SHOW_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShow(boolean newShow) {
		_dgraphic.getProperties().store(DGraphic.P_SHOW_LEGEND, newShow);
		showESet = true;		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetShow() {
		showESet = false;
		//_dgraphic.getProperties().store(DGraphic.P_SHOW_LEGEND, SHOW_EDEFAULT);
		_dgraphic.getProperties().remove(DGraphic.P_SHOW_LEGEND);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetShow() {
		if (showESet == false) {
			isShow();
		}
		return showESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTitle() {
		String title = (String) _dgraphic.getProperties().get(DGraphic.P_LEGEND_LABEL);
		if (title != null && title != "")
			return title;
		else
			return null;
	}

//  if ((n=attr.getNamedItem("tooltip")) != null) 
//  g.getProperties().store(DGraphic.P_LEGEND_TOOLTIP, n.getNodeValue());
//if ((n=attr.getNamedItem("show")) != null) 
//  g.getProperties().store(DGraphic.P_SHOW_LEGEND, Boolean.valueOf(n.getNodeValue()));
//if ((n=attr.getNamedItem("backgroundColor")) != null) 
//  g.getProperties().store(DGraphic.P_LEGEND_BACKCOLOR, getColor(n.getNodeValue(), "chart"));
//if ((n=attr.getNamedItem("width")) != null) 
//  g.getProperties().get(DGraphic.P_LEGEND_WIDTH, Float.parseFloat(n.getNodeValue()));
//if ((n=attr.getNamedItem("height")) != null) 
//  g.getProperties().get(DGraphic.P_LEGEND_HEIGHT, Float.parseFloat(n.getNodeValue()));
//g.getProperties().store(DGraphic.P_LEGEND_LABEL, 
//                      getRequiredAttribut(attr, "label", "legend").getNodeValue());
//if ((n=attr.getNamedItem("legendLimit")) != null) 
//  g.getProperties().get(DGraphic.P_LEGEND_LIMIT, n.getNodeValue());
//if ((n=attr.getNamedItem("layout")) != null) 
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTitle(String newTitle) {
		_dgraphic.getProperties().store(DGraphic.P_LEGEND_LABEL, newTitle);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getHeight() {
		String loc = getLocation();
		if ((_dgraphic.getProperties().get(DGraphic.P_LEGEND_LIMIT) != null)){
			int sizingFactor = ((Integer)_dgraphic.getProperties().get(DGraphic.P_LEGEND_LIMIT, new Integer(4))).intValue();
			if (sizingFactor != 4){
				heightESet = true;
				if ((loc.equals("S")) || (loc.equals("N"))){
					return (_chart.getConfiguration().getSize().getHeight()/(double)sizingFactor);
				}
			}
		}
		return HEIGHT_EDEFAULT;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHeight(double newHeight) {
//		_dgraphic.getProperties().store(DGraphic.P_LEGEND_HEIGHT, new Float(newHeight));
//		heightESet = true;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetHeight() {
		heightESet = false;
		//_dgraphic.getProperties().store(DGraphic.P_LEGEND_HEIGHT, new Float(HEIGHT_EDEFAULT));
		_dgraphic.getProperties().remove(DGraphic.P_LEGEND_HEIGHT);
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetHeight() {
		if (heightESet == false) {
			getHeight();
		}
		return heightESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getWidth() {
		
		String loc = getLocation();
		if (_dgraphic.getProperties().get(DGraphic.P_LEGEND_LIMIT) != null)
			widthESet = true;
		if ((loc.equals("E")) || (loc.equals("W"))){
			int sizingFactor = ((Integer)_dgraphic.getProperties().get(DGraphic.P_LEGEND_LIMIT, new Integer(4))).intValue();
			return (_chart.getConfiguration().getSize().getWidth()/(double)sizingFactor);
		}
		return WIDTH_EDEFAULT;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWidth(double newWidth) {
//		_dgraphic.getProperties().store(DGraphic.P_LEGEND_WIDTH, new Float(newWidth));
//		widthESet = true;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetWidth() {
		widthESet = false;
		//_dgraphic.getProperties().store(DGraphic.P_LEGEND_WIDTH, new Float(WIDTH_EDEFAULT));
		_dgraphic.getProperties().remove(DGraphic.P_LEGEND_WIDTH);
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetWidth() {
		if (widthESet == false) {
			getWidth();
		}
		return widthESet;

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(getId());
		result.append(", location: ");
		if (locationESet) result.append(getLocation()); else result.append("<unset>");
		result.append(", show: ");
		if (showESet) result.append(isShow()); else result.append("<unset>");
		result.append(", title: ");
		if (widthESet) result.append(getWidth()); else result.append("<unset>");
		result.append(", title: ");
		if (heightESet) result.append(getHeight()); else result.append("<unset>");
		result.append(", title: ");
		result.append(getTitle());
		result.append(')');
		return result.toString();
	}

	public int getMargin() {
		if (_dgraphic.getProperties().get(DGraphic.P_MARGIN) != null)
			marginESet = true;
		return ((Integer)_dgraphic.getProperties().get(DGraphic.P_MARGIN, new Integer(MARGIN_EDEFAULT))).intValue();
	}

	public void setMargin(int value) {
		_dgraphic.getProperties().store(DGraphic.P_MARGIN, new Float(value));
		marginESet = true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetMagin() {
		marginESet = false;
		_dgraphic.getProperties().store(DGraphic.P_MARGIN, new Integer(MARGIN_EDEFAULT));
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetMagin() {
		if (marginESet == false) {
			getMargin();
		}
		return marginESet;
	}
	
} //LegendImpl
