/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGMarkerLineImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGMarkerLineImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerLine;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.IDColor;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Marker Line</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerLineImpl#getColor <em>Color</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerLineImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerLineImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerLineImpl#getValue <em>Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGMarkerLineImpl extends SVGInputBase implements MarkerLine {
	/**
	 * The default value of the '{@link #getColor() <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColor()
	 * @generated
	 * @ordered
	 */
	protected static final String COLOR_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getThickness() <em>Thickness</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThickness()
	 * @generated
	 * @ordered
	 */
	protected static final double THICKNESS_EDEFAULT = 0.0;

	/**
	 * This is true if the Thickness attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean thicknessESet = false;

	/**
	 * The default value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected static final double VALUE_EDEFAULT = 0.0;

	/**
	 * This is true if the Value attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean valueESet = false;
	
	protected DMarkerLine markerline = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGMarkerLineImpl() {
		super();
	}

	public SVGMarkerLineImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null);
	}

	public SVGMarkerLineImpl(Chart chart, DGraphic dgraphic, DMarkerLine markerline) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.markerline = markerline;
	}
	

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetThickness() {
		thicknessESet = false;
		this.setThickness(THICKNESS_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetThickness() {
		if (thicknessESet == false) {
			getThickness();
		}
		return thicknessESet;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetValue() {
		valueESet = false;
		this.setValue(VALUE_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetValue() {
		if (valueESet == false) {
			getValue();
		}
		return valueESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (color: ");
		result.append(getColor());
		result.append(", id: ");
		result.append(getId());
		result.append(", label: ");
		result.append(getLabel());
		result.append(", thickness: ");
		if (thicknessESet) result.append(getThickness()); else result.append("<unset>");
		result.append(", value: ");
		if (valueESet) result.append(getValue()); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

	/**
	 * @return
	 */
	public String getColor() {
		IDColor color = markerline.getColor();
		if (color != null)
			return color.serializeToString();
		else 
			return null;
	}
	/**
	 * @return
	 */
	public String getId() {
		return markerline.getId();
	}
	/**
	 * @return
	 */
	public String getLabel() {
		return markerline.getLabel();
	}
	/**
	 * @return
	 */
	public double getThickness() {
		if (markerline.getThickness() != THICKNESS_EDEFAULT)
			thicknessESet = true;
		return markerline.getThickness();
	}
	/**
	 * @return
	 */
	public double getValue() {
		Object value = markerline.getValue();
		if (value instanceof Double) {
			valueESet = true;
			return ((Double)value).doubleValue();
		}
		return VALUE_EDEFAULT;
	}
	/**
	 * @param color
	 */
	public void setColor(String newColor) {
		if (newColor != null && newColor != "" && !newColor.substring(0, 1).equals("#"))  // if the color name is not "#......"
			newColor = convertToHex(newColor);
		if (newColor == null  || newColor == "") {	// if not matched, use black as default
			newColor = "#000000";	
		}
		IDColor color = markerline.getColor();
		if (color == null) {
			color = new DColor();
		}
		color.serializeFromString(newColor);
		markerline.setColor(color);
	}
	/**
	 * @param id
	 */
	public void setId(String id) {
		markerline.setId(id);
	}
	/**
	 * @param label
	 */
	public void setLabel(String label) {
		markerline.setLabel(label);
	}
	/**
	 * @param thikness
	 */
	public void setThickness(double thickness) {
		markerline.setThickness(thickness);
	}
	/**
	 * @param value
	 */
	public void setValue(double value) {
		markerline.setValue(new  Double(value));
	}
	
	// function for model construction
	public DMarkerLine getDMarkerLine() {
		return markerline;
	}
} //MarkerLineImpl
