/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGMarkerRegionImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGMarkerRegionImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerRegion;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DMarkerRegion;
import org.eclipse.tptp.platform.report.core.internal.IDColor;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Marker Region</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerRegionImpl#getColor <em>Color</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerRegionImpl#getFromValue <em>From Value</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerRegionImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerRegionImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerRegionImpl#getToValue <em>To Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGMarkerRegionImpl extends SVGInputBase implements MarkerRegion {
	/**
	 * The default value of the '{@link #getColor() <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColor()
	 * @generated
	 * @ordered
	 */
	protected static final String COLOR_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getFromValue() <em>From Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFromValue()
	 * @generated
	 * @ordered
	 */
	protected static final double FROM_VALUE_EDEFAULT = 0.0;

	/**
	 * This is true if the From Value attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean fromValueESet = false;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getToValue() <em>To Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToValue()
	 * @generated
	 * @ordered
	 */
	protected static final double TO_VALUE_EDEFAULT = 0.0;

	/**
	 * @return
	 */
	public String getColor() {
		IDColor color = markerregion.getColor();
		if (color != null)
			return color.serializeToString();
		else 
			return null;
	}

	/**
	 * @return
	 */
	public double getFromValue() {
		Object value = markerregion.getFromValue();
		if (value instanceof Double) {
			fromValueESet = true;
			return ((Double)value).doubleValue();
		}
		return FROM_VALUE_EDEFAULT;
	}

	/**
	 * @return
	 */
	public String getId() {
		return markerregion.getId();
	}
	/**
	 * @return
	 */
	public String getLabel() {
		return markerregion.getLabel();
	}
	/**
	 * @return
	 */
	public double getToValue() {
		Object value = markerregion.getToValue();
		if (value instanceof Double) {
			toValueESet = true;
			return ((Double)value).doubleValue();
		}
		return TO_VALUE_EDEFAULT;
	}

	/**
	 * @param color
	 */
	public void setColor(String newColor) {
		if (newColor != null && newColor != "" && !newColor.substring(0, 1).equals("#"))  // if the color name is not "#......"
			newColor = convertToHex(newColor);
		if (newColor == null || newColor == "") {	// if not matched, use black as default
			newColor = "#000000";	
		}
		IDColor color = markerregion.getColor();
		if (color == null) {
			color = new DColor();
		}
		color.serializeFromString(newColor);
		markerregion.setColor(color);
	}	/**
	 * @param fromValue
	 */
	public void setFromValue(double fromValue) {
		markerregion.setFromValue(new Double(fromValue));
	}
	/**
	 * @param id
	 */
	public void setId(String id) {
		markerregion.setId(id);
	}
	/**
	 * @param label
	 */
	public void setLabel(String label) {
		markerregion.setLabel(label);
	}
	/**
	 * @param toValue
	 */
	public void setToValue(double toValue) {
		markerregion.setToValue(new Double(toValue));
	}
	/**
	 * This is true if the To Value attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean toValueESet = false;

	protected DMarkerRegion markerregion = null;
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGMarkerRegionImpl() {
		super();
	}

	public SVGMarkerRegionImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null);
	}

	public SVGMarkerRegionImpl(Chart chart, DGraphic dgraphic, DMarkerRegion markerregion) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.markerregion = markerregion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetFromValue() {
		fromValueESet = false;
		this.setFromValue(FROM_VALUE_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetFromValue() {
		if (fromValueESet == false) {
			getFromValue();
		}
		return fromValueESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetToValue() {
		toValueESet = false;
		this.setFromValue(TO_VALUE_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetToValue() {
		if (toValueESet == false) {
			getToValue();
		}
		return toValueESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (color: ");
		result.append(getColor());
		result.append(", fromValue: ");
		if (fromValueESet) result.append(getFromValue()); else result.append("<unset>");
		result.append(", id: ");
		result.append(getId());
		result.append(", label: ");
		result.append(getLabel());
		result.append(", toValue: ");
		if (toValueESet) result.append(getToValue()); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

	// function for model construction
	public DMarkerRegion getDMarkerRegion() {
		return markerregion;
	}
	
} //MarkerRegionImpl
