/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPalettesImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPalettesImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Palettes;

import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPalettes;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Palettes</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGPalettesImpl#getLocation <em>Location</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGPalettesImpl extends SVGInputBase implements Palettes {
	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCATION_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getPaletteId() <em>Palette Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPaletteId()
	 * @generated
	 * @ordered
	 */
	protected static final String PALETTE_ID_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getPaletteSetId() <em>Palette Set Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPaletteSetId()
	 * @generated
	 * @ordered
	 */
	protected static final String PALETTE_SET_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPaletteSetId() <em>Palette Set Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPaletteSetId()
	 * @generated
	 * @ordered
	 */
	protected String paletteSetId = PALETTE_SET_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDataSetColor() <em>Data Set Color</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSetColor()
	 * @generated
	 * @ordered
	 */
	protected List dataSetColor = null;
	
    protected DPalettes pal = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGPalettesImpl() {
		super();
	}

	public SVGPalettesImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}


	public SVGPalettesImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
		pal = (DPalettes)_dgraphic.getChildOfClass(DPalettes.class);
		if (pal == null) pal = new DPalettes();
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getDataSetColor() {
		if (dataSetColor == null) {
			if (_dgraphic != null) {
				dataSetColor = new ArrayList();
				for (IDItem item = _dgraphic.getFirstChild(); item!=null;item=item.getNext()) {
					if ((item instanceof DCurve) && (SVGDataSetColorImpl.hasColor((DCurve)item)))
						dataSetColor.add(new SVGDataSetColorImpl(_chart, _dgraphic, (DCurve)item));
				}
			} else {
				dataSetColor = new ArrayList();
			}
		}
		return dataSetColor;
	}

	// function for assignment
	public void setDataSetColor(List newDataSetColor) {
		dataSetColor = newDataSetColor;
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (location: ");
		result.append(getLocation());
		result.append(", paletteId: ");
		result.append(getPaletteId());
		result.append(", paletteSetId: ");
		result.append(paletteSetId);
		result.append(')');
		return result.toString();
	}

	/**
	 * @return
	 */
	public String getLocation() {
		return pal.getLocation();
	}
	/**
	 * @return
	 */
	public String getPaletteId() {
		return pal.getPaletteId();
	}
	/**
	 * @param location
	 */
	public void setLocation(String location) {
		pal.setLocation(location);
	}
	/**
	 * @param paletteId
	 */
	public void setPaletteId(String paletteId) {
		pal.setPaletteId(paletteId);
	}
	/**
	 * @return
	 */
	public String getPaletteSetId() {
		return pal.getPaletteSetId();
	}
	/**
	 * @param paletteSetId
	 */
	public void setPaletteSetId(String paletteSetId) {
		pal.setPaletteSetId(paletteSetId);
	}
	
	// function for assignment
	public void constructModel() {
		if (_dgraphic.getChildOfClass(DPalettes.class) == null)
			_dgraphic.addChild(pal);
	}
} //PalettesImpl
